/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.exoplayer.text.CaptionStyleCompat;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.util.Util;

final class CuePainter {
    private static final String TAG = "CuePainter";
    private static final float INNER_PADDING_RATIO = 0.125f;
    private final RectF lineBounds = new RectF();
    private final float cornerRadius;
    private final float outlineWidth;
    private final float shadowRadius;
    private final float shadowOffset;
    private final float spacingMult;
    private final float spacingAdd;
    private final TextPaint textPaint;
    private final Paint paint;
    private CharSequence cueText;
    private Layout.Alignment cueTextAlignment;
    private float cueLine;
    private int cueLineType;
    private int cueLineAnchor;
    private float cuePosition;
    private int cuePositionAnchor;
    private float cueSize;
    private boolean applyEmbeddedStyles;
    private int foregroundColor;
    private int backgroundColor;
    private int windowColor;
    private int edgeColor;
    private int edgeType;
    private float textSizePx;
    private float bottomPaddingFraction;
    private int parentLeft;
    private int parentTop;
    private int parentRight;
    private int parentBottom;
    private StaticLayout textLayout;
    private int textLeft;
    private int textTop;
    private int textPaddingX;

    public CuePainter(Context context) {
        int[] viewAttr = new int[]{16843287, 16843288};
        TypedArray styledAttributes = context.obtainStyledAttributes(null, viewAttr, 0, 0);
        this.spacingAdd = styledAttributes.getDimensionPixelSize(0, 0);
        this.spacingMult = styledAttributes.getFloat(1, 1.0f);
        styledAttributes.recycle();
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        int twoDpInPx = Math.round(2.0f * (float)displayMetrics.densityDpi / 160.0f);
        this.cornerRadius = twoDpInPx;
        this.outlineWidth = twoDpInPx;
        this.shadowRadius = twoDpInPx;
        this.shadowOffset = twoDpInPx;
        this.textPaint = new TextPaint();
        this.textPaint.setAntiAlias(true);
        this.textPaint.setSubpixelText(true);
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL);
    }

    public void draw(Cue cue, boolean applyEmbeddedStyles, CaptionStyleCompat style, float textSizePx, float bottomPaddingFraction, Canvas canvas, int cueBoxLeft, int cueBoxTop, int cueBoxRight, int cueBoxBottom) {
        int textTop;
        int textRight;
        int textLeft;
        CharSequence cueText = cue.text;
        if (TextUtils.isEmpty((CharSequence)cueText)) {
            return;
        }
        if (!applyEmbeddedStyles) {
            cueText = cueText.toString();
        }
        if (CuePainter.areCharSequencesEqual(this.cueText, cueText) && Util.areEqual(this.cueTextAlignment, cue.textAlignment) && this.cueLine == cue.line && this.cueLineType == cue.lineType && Util.areEqual(this.cueLineAnchor, cue.lineAnchor) && this.cuePosition == cue.position && Util.areEqual(this.cuePositionAnchor, cue.positionAnchor) && this.cueSize == cue.size && this.applyEmbeddedStyles == applyEmbeddedStyles && this.foregroundColor == style.foregroundColor && this.backgroundColor == style.backgroundColor && this.windowColor == style.windowColor && this.edgeType == style.edgeType && this.edgeColor == style.edgeColor && Util.areEqual(this.textPaint.getTypeface(), style.typeface) && this.textSizePx == textSizePx && this.bottomPaddingFraction == bottomPaddingFraction && this.parentLeft == cueBoxLeft && this.parentTop == cueBoxTop && this.parentRight == cueBoxRight && this.parentBottom == cueBoxBottom) {
            this.drawLayout(canvas);
            return;
        }
        this.cueText = cueText;
        this.cueTextAlignment = cue.textAlignment;
        this.cueLine = cue.line;
        this.cueLineType = cue.lineType;
        this.cueLineAnchor = cue.lineAnchor;
        this.cuePosition = cue.position;
        this.cuePositionAnchor = cue.positionAnchor;
        this.cueSize = cue.size;
        this.applyEmbeddedStyles = applyEmbeddedStyles;
        this.foregroundColor = style.foregroundColor;
        this.backgroundColor = style.backgroundColor;
        this.windowColor = style.windowColor;
        this.edgeType = style.edgeType;
        this.edgeColor = style.edgeColor;
        this.textPaint.setTypeface(style.typeface);
        this.textSizePx = textSizePx;
        this.bottomPaddingFraction = bottomPaddingFraction;
        this.parentLeft = cueBoxLeft;
        this.parentTop = cueBoxTop;
        this.parentRight = cueBoxRight;
        this.parentBottom = cueBoxBottom;
        int parentWidth = this.parentRight - this.parentLeft;
        int parentHeight = this.parentBottom - this.parentTop;
        this.textPaint.setTextSize(textSizePx);
        int textPaddingX = (int)(textSizePx * 0.125f + 0.5f);
        int availableWidth = parentWidth - textPaddingX * 2;
        if (this.cueSize != Float.MIN_VALUE) {
            availableWidth = (int)((float)availableWidth * this.cueSize);
        }
        if (availableWidth <= 0) {
            Log.w((String)TAG, (String)"Skipped drawing subtitle cue (insufficient space)");
            return;
        }
        Layout.Alignment textAlignment = this.cueTextAlignment == null ? Layout.Alignment.ALIGN_CENTER : this.cueTextAlignment;
        this.textLayout = new StaticLayout(cueText, this.textPaint, availableWidth, textAlignment, this.spacingMult, this.spacingAdd, true);
        int textHeight = this.textLayout.getHeight();
        int textWidth = 0;
        int lineCount = this.textLayout.getLineCount();
        for (int i = 0; i < lineCount; ++i) {
            textWidth = Math.max((int)Math.ceil(this.textLayout.getLineWidth(i)), textWidth);
        }
        if (this.cueSize != Float.MIN_VALUE && textWidth < availableWidth) {
            textWidth = availableWidth;
        }
        textWidth += textPaddingX * 2;
        if (this.cuePosition != Float.MIN_VALUE) {
            int anchorPosition = Math.round((float)parentWidth * this.cuePosition) + this.parentLeft;
            textLeft = this.cuePositionAnchor == 2 ? anchorPosition - textWidth : (this.cuePositionAnchor == 1 ? (anchorPosition * 2 - textWidth) / 2 : anchorPosition);
            textLeft = Math.max(textLeft, this.parentLeft);
            textRight = Math.min(textLeft + textWidth, this.parentRight);
        } else {
            textLeft = (parentWidth - textWidth) / 2;
            textRight = textLeft + textWidth;
        }
        if (this.cueLine != Float.MIN_VALUE) {
            int anchorPosition;
            if (this.cueLineType == 0) {
                anchorPosition = Math.round((float)parentHeight * this.cueLine) + this.parentTop;
            } else {
                int firstLineHeight = this.textLayout.getLineBottom(0) - this.textLayout.getLineTop(0);
                anchorPosition = this.cueLine >= 0.0f ? Math.round(this.cueLine * (float)firstLineHeight) + this.parentTop : Math.round(this.cueLine * (float)firstLineHeight) + this.parentBottom;
            }
            textTop = this.cueLineAnchor == 2 ? anchorPosition - textHeight : (this.cueLineAnchor == 1 ? (anchorPosition * 2 - textHeight) / 2 : anchorPosition);
            int textBottom = textTop + textHeight;
            if (textBottom > this.parentBottom) {
                textTop = this.parentBottom - textHeight;
                textBottom = this.parentBottom;
            } else if (textTop < this.parentTop) {
                textTop = this.parentTop;
                textBottom = this.parentTop + textHeight;
            }
        } else {
            textTop = this.parentBottom - textHeight - (int)((float)parentHeight * bottomPaddingFraction);
            int textBottom = textTop + textHeight;
        }
        textWidth = textRight - textLeft;
        this.textLayout = new StaticLayout(cueText, this.textPaint, textWidth, textAlignment, this.spacingMult, this.spacingAdd, true);
        this.textLeft = textLeft;
        this.textTop = textTop;
        this.textPaddingX = textPaddingX;
        this.drawLayout(canvas);
    }

    private void drawLayout(Canvas canvas) {
        StaticLayout layout = this.textLayout;
        if (layout == null) {
            return;
        }
        int saveCount = canvas.save();
        canvas.translate((float)this.textLeft, (float)this.textTop);
        if (Color.alpha((int)this.windowColor) > 0) {
            this.paint.setColor(this.windowColor);
            canvas.drawRect((float)(-this.textPaddingX), 0.0f, (float)(layout.getWidth() + this.textPaddingX), (float)layout.getHeight(), this.paint);
        }
        if (Color.alpha((int)this.backgroundColor) > 0) {
            this.paint.setColor(this.backgroundColor);
            float previousBottom = layout.getLineTop(0);
            int lineCount = layout.getLineCount();
            for (int i = 0; i < lineCount; ++i) {
                this.lineBounds.left = layout.getLineLeft(i) - (float)this.textPaddingX;
                this.lineBounds.right = layout.getLineRight(i) + (float)this.textPaddingX;
                this.lineBounds.top = previousBottom;
                previousBottom = this.lineBounds.bottom = (float)layout.getLineBottom(i);
                canvas.drawRoundRect(this.lineBounds, this.cornerRadius, this.cornerRadius, this.paint);
            }
        }
        if (this.edgeType == 1) {
            this.textPaint.setStrokeJoin(Paint.Join.ROUND);
            this.textPaint.setStrokeWidth(this.outlineWidth);
            this.textPaint.setColor(this.edgeColor);
            this.textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            layout.draw(canvas);
        } else if (this.edgeType == 2) {
            this.textPaint.setShadowLayer(this.shadowRadius, this.shadowOffset, this.shadowOffset, this.edgeColor);
        } else if (this.edgeType == 3 || this.edgeType == 4) {
            boolean raised = this.edgeType == 3;
            int colorUp = raised ? -1 : this.edgeColor;
            int colorDown = raised ? this.edgeColor : -1;
            float offset = this.shadowRadius / 2.0f;
            this.textPaint.setColor(this.foregroundColor);
            this.textPaint.setStyle(Paint.Style.FILL);
            this.textPaint.setShadowLayer(this.shadowRadius, -offset, -offset, colorUp);
            layout.draw(canvas);
            this.textPaint.setShadowLayer(this.shadowRadius, offset, offset, colorDown);
        }
        this.textPaint.setColor(this.foregroundColor);
        this.textPaint.setStyle(Paint.Style.FILL);
        layout.draw(canvas);
        this.textPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        canvas.restoreToCount(saveCount);
    }

    private static boolean areCharSequencesEqual(CharSequence first, CharSequence second) {
        return first == second || first != null && first.equals(second);
    }
}

