/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text;

import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.Subtitle;
import java.util.List;

final class PlayableSubtitle
implements Subtitle {
    public final long startTimeUs;
    private final Subtitle subtitle;
    private final long offsetUs;

    public PlayableSubtitle(Subtitle subtitle, boolean isRelative, long startTimeUs, long offsetUs) {
        this.subtitle = subtitle;
        this.startTimeUs = startTimeUs;
        this.offsetUs = (isRelative ? startTimeUs : 0L) + offsetUs;
    }

    @Override
    public int getEventTimeCount() {
        return this.subtitle.getEventTimeCount();
    }

    @Override
    public long getEventTime(int index) {
        return this.subtitle.getEventTime(index) + this.offsetUs;
    }

    @Override
    public long getLastEventTime() {
        return this.subtitle.getLastEventTime() + this.offsetUs;
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        return this.subtitle.getNextEventTimeIndex(timeUs - this.offsetUs);
    }

    @Override
    public List<Cue> getCues(long timeUs) {
        return this.subtitle.getCues(timeUs - this.offsetUs);
    }
}

