/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.google.android.exoplayer.text.CaptionStyleCompat;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.CuePainter;
import java.util.ArrayList;
import java.util.List;

public final class SubtitleLayout
extends View {
    public static final float DEFAULT_TEXT_SIZE_FRACTION = 0.0533f;
    public static final float DEFAULT_BOTTOM_PADDING_FRACTION = 0.08f;
    private static final int FRACTIONAL = 0;
    private static final int FRACTIONAL_IGNORE_PADDING = 1;
    private static final int ABSOLUTE = 2;
    private final List<CuePainter> painters = new ArrayList<CuePainter>();
    private List<Cue> cues;
    private int textSizeType = 0;
    private float textSize = 0.0533f;
    private boolean applyEmbeddedStyles = true;
    private CaptionStyleCompat style = CaptionStyleCompat.DEFAULT;
    private float bottomPaddingFraction = 0.08f;

    public SubtitleLayout(Context context) {
        this(context, null);
    }

    public SubtitleLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setCues(List<Cue> cues) {
        int cueCount;
        if (this.cues == cues) {
            return;
        }
        this.cues = cues;
        int n = cueCount = cues == null ? 0 : cues.size();
        while (this.painters.size() < cueCount) {
            this.painters.add(new CuePainter(this.getContext()));
        }
        this.invalidate();
    }

    public void setFixedTextSize(int unit, float size) {
        Context context = this.getContext();
        Resources resources = context == null ? Resources.getSystem() : context.getResources();
        this.setTextSize(2, TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)resources.getDisplayMetrics()));
    }

    public void setFractionalTextSize(float fractionOfHeight) {
        this.setFractionalTextSize(fractionOfHeight, false);
    }

    public void setFractionalTextSize(float fractionOfHeight, boolean ignorePadding) {
        this.setTextSize(ignorePadding ? 1 : 0, fractionOfHeight);
    }

    private void setTextSize(int textSizeType, float textSize) {
        if (this.textSizeType == textSizeType && this.textSize == textSize) {
            return;
        }
        this.textSizeType = textSizeType;
        this.textSize = textSize;
        this.invalidate();
    }

    public void setApplyEmbeddedStyles(boolean applyEmbeddedStyles) {
        if (this.applyEmbeddedStyles == applyEmbeddedStyles) {
            return;
        }
        this.applyEmbeddedStyles = applyEmbeddedStyles;
        this.invalidate();
    }

    public void setStyle(CaptionStyleCompat style) {
        if (this.style == style) {
            return;
        }
        this.style = style;
        this.invalidate();
    }

    public void setBottomPaddingFraction(float bottomPaddingFraction) {
        if (this.bottomPaddingFraction == bottomPaddingFraction) {
            return;
        }
        this.bottomPaddingFraction = bottomPaddingFraction;
        this.invalidate();
    }

    public void dispatchDraw(Canvas canvas) {
        float textSizePx;
        int cueCount = this.cues == null ? 0 : this.cues.size();
        int rawTop = this.getTop();
        int rawBottom = this.getBottom();
        int left = this.getLeft() + this.getPaddingLeft();
        int top = rawTop + this.getPaddingTop();
        int right = this.getRight() + this.getPaddingRight();
        int bottom = rawBottom - this.getPaddingBottom();
        if (bottom <= top || right <= left) {
            return;
        }
        float f = this.textSizeType == 2 ? this.textSize : (textSizePx = this.textSize * (float)(this.textSizeType == 0 ? bottom - top : rawBottom - rawTop));
        if (textSizePx <= 0.0f) {
            return;
        }
        for (int i = 0; i < cueCount; ++i) {
            this.painters.get(i).draw(this.cues.get(i), this.applyEmbeddedStyles, this.style, textSizePx, this.bottomPaddingFraction, canvas, left, top, right, bottom);
        }
    }
}

