/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.text.PlayableSubtitle;
import com.google.android.exoplayer.text.Subtitle;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

final class SubtitleParserHelper
implements Handler.Callback {
    private static final int MSG_FORMAT = 0;
    private static final int MSG_SAMPLE = 1;
    private final SubtitleParser parser;
    private final Handler handler;
    private SampleHolder sampleHolder;
    private boolean parsing;
    private PlayableSubtitle result;
    private IOException error;
    private RuntimeException runtimeError;
    private boolean subtitlesAreRelative;
    private long subtitleOffsetUs;

    public SubtitleParserHelper(Looper looper, SubtitleParser parser) {
        this.handler = new Handler(looper, (Handler.Callback)this);
        this.parser = parser;
        this.flush();
    }

    public synchronized void flush() {
        this.sampleHolder = new SampleHolder(1);
        this.parsing = false;
        this.result = null;
        this.error = null;
        this.runtimeError = null;
    }

    public synchronized boolean isParsing() {
        return this.parsing;
    }

    public synchronized SampleHolder getSampleHolder() {
        return this.sampleHolder;
    }

    public void setFormat(MediaFormat format) {
        this.handler.obtainMessage(0, (Object)format).sendToTarget();
    }

    public synchronized void startParseOperation() {
        Assertions.checkState(!this.parsing);
        this.parsing = true;
        this.result = null;
        this.error = null;
        this.runtimeError = null;
        this.handler.obtainMessage(1, Util.getTopInt(this.sampleHolder.timeUs), Util.getBottomInt(this.sampleHolder.timeUs), (Object)this.sampleHolder).sendToTarget();
    }

    public synchronized PlayableSubtitle getAndClearResult() throws IOException {
        try {
            if (this.error != null) {
                throw this.error;
            }
            if (this.runtimeError != null) {
                throw this.runtimeError;
            }
            PlayableSubtitle playableSubtitle = this.result;
            return playableSubtitle;
        }
        finally {
            this.result = null;
            this.error = null;
            this.runtimeError = null;
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.handleFormat((MediaFormat)msg.obj);
                break;
            }
            case 1: {
                long sampleTimeUs = Util.getLong(msg.arg1, msg.arg2);
                SampleHolder holder = (SampleHolder)msg.obj;
                this.handleSample(sampleTimeUs, holder);
            }
        }
        return true;
    }

    private void handleFormat(MediaFormat format) {
        this.subtitlesAreRelative = format.subsampleOffsetUs == Long.MAX_VALUE;
        this.subtitleOffsetUs = this.subtitlesAreRelative ? 0L : format.subsampleOffsetUs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSample(long sampleTimeUs, SampleHolder holder) {
        Subtitle parsedSubtitle = null;
        ParserException error = null;
        RuntimeException runtimeError = null;
        try {
            parsedSubtitle = this.parser.parse(holder.data.array(), 0, holder.size);
        }
        catch (ParserException e) {
            error = e;
        }
        catch (RuntimeException e) {
            runtimeError = e;
        }
        SubtitleParserHelper subtitleParserHelper = this;
        synchronized (subtitleParserHelper) {
            if (this.sampleHolder == holder) {
                this.result = new PlayableSubtitle(parsedSubtitle, this.subtitlesAreRelative, sampleTimeUs, this.subtitleOffsetUs);
                this.error = error;
                this.runtimeError = runtimeError;
                this.parsing = false;
            }
        }
    }
}

