/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.subrip;

import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.subrip.SubripSubtitle;
import com.google.android.exoplayer.util.LongArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SubripParser
implements SubtitleParser {
    private static final String TAG = "SubripParser";
    private static final Pattern SUBRIP_TIMING_LINE = Pattern.compile("(\\S*)\\s*-->\\s*(\\S*)");
    private static final Pattern SUBRIP_TIMESTAMP = Pattern.compile("(?:(\\d+):)?(\\d+):(\\d+),(\\d+)");
    private final StringBuilder textBuilder = new StringBuilder();

    @Override
    public boolean canParse(String mimeType) {
        return "application/x-subrip".equals(mimeType);
    }

    @Override
    public SubripSubtitle parse(byte[] bytes, int offset, int length) {
        String currentLine;
        ArrayList<Cue> cues = new ArrayList<Cue>();
        LongArray cueTimesUs = new LongArray();
        ParsableByteArray subripData = new ParsableByteArray(bytes, offset + length);
        subripData.setPosition(offset);
        while ((currentLine = subripData.readLine()) != null) {
            if (currentLine.length() == 0) continue;
            try {
                Integer.parseInt(currentLine);
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)("Skipping invalid index: " + currentLine));
                continue;
            }
            boolean haveEndTimecode = false;
            currentLine = subripData.readLine();
            Matcher matcher = SUBRIP_TIMING_LINE.matcher(currentLine);
            if (matcher.find()) {
                cueTimesUs.add(SubripParser.parseTimecode(matcher.group(1)));
                String endTimecode = matcher.group(2);
                if (!TextUtils.isEmpty((CharSequence)endTimecode)) {
                    haveEndTimecode = true;
                    cueTimesUs.add(SubripParser.parseTimecode(matcher.group(2)));
                }
            } else {
                Log.w((String)TAG, (String)("Skipping invalid timing: " + currentLine));
                continue;
            }
            this.textBuilder.setLength(0);
            while (!TextUtils.isEmpty((CharSequence)(currentLine = subripData.readLine()))) {
                if (this.textBuilder.length() > 0) {
                    this.textBuilder.append("<br>");
                }
                this.textBuilder.append(currentLine.trim());
            }
            Spanned text = Html.fromHtml((String)this.textBuilder.toString());
            cues.add(new Cue((CharSequence)text));
            if (!haveEndTimecode) continue;
            cues.add(null);
        }
        Cue[] cuesArray = new Cue[cues.size()];
        cues.toArray(cuesArray);
        long[] cueTimesUsArray = cueTimesUs.toArray();
        return new SubripSubtitle(cuesArray, cueTimesUsArray);
    }

    private static long parseTimecode(String s) throws NumberFormatException {
        Matcher matcher = SUBRIP_TIMESTAMP.matcher(s);
        if (!matcher.matches()) {
            throw new NumberFormatException("has invalid format");
        }
        long timestampMs = Long.parseLong(matcher.group(1)) * 60L * 60L * 1000L;
        timestampMs += Long.parseLong(matcher.group(2)) * 60L * 1000L;
        timestampMs += Long.parseLong(matcher.group(3)) * 1000L;
        return (timestampMs += Long.parseLong(matcher.group(4))) * 1000L;
    }
}

