/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.ttml;

import android.text.Layout;
import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.ttml.TtmlColorParser;
import com.google.android.exoplayer.text.ttml.TtmlNode;
import com.google.android.exoplayer.text.ttml.TtmlRegion;
import com.google.android.exoplayer.text.ttml.TtmlStyle;
import com.google.android.exoplayer.text.ttml.TtmlSubtitle;
import com.google.android.exoplayer.util.ParserUtil;
import com.google.android.exoplayer.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public final class TtmlParser
implements SubtitleParser {
    private static final String TAG = "TtmlParser";
    private static final String TTP = "http://www.w3.org/ns/ttml#parameter";
    private static final String ATTR_BEGIN = "begin";
    private static final String ATTR_DURATION = "dur";
    private static final String ATTR_END = "end";
    private static final String ATTR_STYLE = "style";
    private static final String ATTR_REGION = "region";
    private static final Pattern CLOCK_TIME = Pattern.compile("^([0-9][0-9]+):([0-9][0-9]):([0-9][0-9])(?:(\\.[0-9]+)|:([0-9][0-9])(?:\\.([0-9]+))?)?$");
    private static final Pattern OFFSET_TIME = Pattern.compile("^([0-9]+(?:\\.[0-9]+)?)(h|m|s|ms|f|t)$");
    private static final Pattern FONT_SIZE = Pattern.compile("^(([0-9]*.)?[0-9]+)(px|em|%)$");
    private static final Pattern PERCENTAGE_COORDINATES = Pattern.compile("^(\\d+\\.?\\d*?)% (\\d+\\.?\\d*?)%$");
    private static final int DEFAULT_FRAME_RATE = 30;
    private static final FrameAndTickRate DEFAULT_FRAME_AND_TICK_RATE = new FrameAndTickRate(30.0f, 1, 1);
    private final XmlPullParserFactory xmlParserFactory;

    public TtmlParser() {
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
            this.xmlParserFactory.setNamespaceAware(true);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", e);
        }
    }

    @Override
    public boolean canParse(String mimeType) {
        return "application/ttml+xml".equals(mimeType);
    }

    @Override
    public TtmlSubtitle parse(byte[] bytes, int offset, int length) throws ParserException {
        try {
            XmlPullParser xmlParser = this.xmlParserFactory.newPullParser();
            HashMap<String, TtmlStyle> globalStyles = new HashMap<String, TtmlStyle>();
            HashMap<String, TtmlRegion> regionMap = new HashMap<String, TtmlRegion>();
            regionMap.put("", new TtmlRegion());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes, offset, length);
            xmlParser.setInput((InputStream)inputStream, null);
            TtmlSubtitle ttmlSubtitle = null;
            LinkedList<TtmlNode> nodeStack = new LinkedList<TtmlNode>();
            int unsupportedNodeDepth = 0;
            int eventType = xmlParser.getEventType();
            FrameAndTickRate frameAndTickRate = DEFAULT_FRAME_AND_TICK_RATE;
            while (eventType != 1) {
                TtmlNode parent = (TtmlNode)nodeStack.peekLast();
                if (unsupportedNodeDepth == 0) {
                    String name = xmlParser.getName();
                    if (eventType == 2) {
                        if ("tt".equals(name)) {
                            frameAndTickRate = this.parseFrameAndTickRates(xmlParser);
                        }
                        if (!TtmlParser.isSupportedTag(name)) {
                            Log.i((String)TAG, (String)("Ignoring unsupported tag: " + xmlParser.getName()));
                            ++unsupportedNodeDepth;
                        } else if ("head".equals(name)) {
                            this.parseHeader(xmlParser, globalStyles, regionMap);
                        } else {
                            try {
                                TtmlNode node = this.parseNode(xmlParser, parent, regionMap, frameAndTickRate);
                                nodeStack.addLast(node);
                                if (parent != null) {
                                    parent.addChild(node);
                                }
                            }
                            catch (ParserException e) {
                                Log.w((String)TAG, (String)"Suppressing parser error", (Throwable)e);
                                ++unsupportedNodeDepth;
                            }
                        }
                    } else if (eventType == 4) {
                        parent.addChild(TtmlNode.buildTextNode(xmlParser.getText()));
                    } else if (eventType == 3) {
                        if (xmlParser.getName().equals("tt")) {
                            ttmlSubtitle = new TtmlSubtitle((TtmlNode)nodeStack.getLast(), globalStyles, regionMap);
                        }
                        nodeStack.removeLast();
                    }
                } else if (eventType == 2) {
                    ++unsupportedNodeDepth;
                } else if (eventType == 3) {
                    --unsupportedNodeDepth;
                }
                xmlParser.next();
                eventType = xmlParser.getEventType();
            }
            return ttmlSubtitle;
        }
        catch (XmlPullParserException xppe) {
            throw new ParserException("Unable to parse source", xppe);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error when reading input.", e);
        }
    }

    private FrameAndTickRate parseFrameAndTickRates(XmlPullParser xmlParser) throws ParserException {
        int frameRate = 30;
        String frameRateStr = xmlParser.getAttributeValue(TTP, "frameRate");
        if (frameRateStr != null) {
            frameRate = Integer.parseInt(frameRateStr);
        }
        float frameRateMultiplier = 1.0f;
        String frameRateMultiplierStr = xmlParser.getAttributeValue(TTP, "frameRateMultiplier");
        if (frameRateMultiplierStr != null) {
            String[] parts = frameRateMultiplierStr.split(" ");
            if (parts.length != 2) {
                throw new ParserException("frameRateMultiplier doesn't have 2 parts");
            }
            float numerator = Integer.parseInt(parts[0]);
            float denominator = Integer.parseInt(parts[1]);
            frameRateMultiplier = numerator / denominator;
        }
        int subFrameRate = TtmlParser.DEFAULT_FRAME_AND_TICK_RATE.subFrameRate;
        String subFrameRateStr = xmlParser.getAttributeValue(TTP, "subFrameRate");
        if (subFrameRateStr != null) {
            subFrameRate = Integer.parseInt(subFrameRateStr);
        }
        int tickRate = TtmlParser.DEFAULT_FRAME_AND_TICK_RATE.tickRate;
        String tickRateStr = xmlParser.getAttributeValue(TTP, "tickRate");
        if (tickRateStr != null) {
            tickRate = Integer.parseInt(tickRateStr);
        }
        return new FrameAndTickRate((float)frameRate * frameRateMultiplier, subFrameRate, tickRate);
    }

    private Map<String, TtmlStyle> parseHeader(XmlPullParser xmlParser, Map<String, TtmlStyle> globalStyles, Map<String, TtmlRegion> globalRegions) throws IOException, XmlPullParserException {
        do {
            Pair<String, TtmlRegion> ttmlRegionInfo;
            xmlParser.next();
            if (ParserUtil.isStartTag(xmlParser, ATTR_STYLE)) {
                String parentStyleId = ParserUtil.getAttributeValue(xmlParser, ATTR_STYLE);
                TtmlStyle style = this.parseStyleAttributes(xmlParser, new TtmlStyle());
                if (parentStyleId != null) {
                    String[] ids = this.parseStyleIds(parentStyleId);
                    for (int i = 0; i < ids.length; ++i) {
                        style.chain(globalStyles.get(ids[i]));
                    }
                }
                if (style.getId() == null) continue;
                globalStyles.put(style.getId(), style);
                continue;
            }
            if (!ParserUtil.isStartTag(xmlParser, ATTR_REGION) || (ttmlRegionInfo = this.parseRegionAttributes(xmlParser)) == null) continue;
            globalRegions.put((String)ttmlRegionInfo.first, (TtmlRegion)ttmlRegionInfo.second);
        } while (!ParserUtil.isEndTag(xmlParser, "head"));
        return globalStyles;
    }

    private Pair<String, TtmlRegion> parseRegionAttributes(XmlPullParser xmlParser) {
        Matcher extentMatcher;
        String regionId = ParserUtil.getAttributeValue(xmlParser, "id");
        String regionOrigin = ParserUtil.getAttributeValue(xmlParser, "origin");
        String regionExtent = ParserUtil.getAttributeValue(xmlParser, "extent");
        if (regionOrigin == null || regionId == null) {
            return null;
        }
        float position = Float.MIN_VALUE;
        float line = Float.MIN_VALUE;
        Matcher originMatcher = PERCENTAGE_COORDINATES.matcher(regionOrigin);
        if (originMatcher.matches()) {
            try {
                position = Float.parseFloat(originMatcher.group(1)) / 100.0f;
                line = Float.parseFloat(originMatcher.group(2)) / 100.0f;
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)("Ignoring region with malformed origin: '" + regionOrigin + "'"), (Throwable)e);
                position = Float.MIN_VALUE;
            }
        }
        float width = Float.MIN_VALUE;
        if (regionExtent != null && (extentMatcher = PERCENTAGE_COORDINATES.matcher(regionExtent)).matches()) {
            try {
                width = Float.parseFloat(extentMatcher.group(1)) / 100.0f;
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)("Ignoring malformed region extent: '" + regionExtent + "'"), (Throwable)e);
            }
        }
        return position != Float.MIN_VALUE ? new Pair((Object)regionId, (Object)new TtmlRegion(position, line, 0, width)) : null;
    }

    private String[] parseStyleIds(String parentStyleIds) {
        return parentStyleIds.split("\\s+");
    }

    private TtmlStyle parseStyleAttributes(XmlPullParser parser, TtmlStyle style) {
        int attributeCount = parser.getAttributeCount();
        block54: for (int i = 0; i < attributeCount; ++i) {
            String attributeValue = parser.getAttributeValue(i);
            switch (parser.getAttributeName(i)) {
                case "id": {
                    if (!ATTR_STYLE.equals(parser.getName())) continue block54;
                    style = this.createIfNull(style).setId(attributeValue);
                    continue block54;
                }
                case "backgroundColor": {
                    style = this.createIfNull(style);
                    try {
                        style.setBackgroundColor(TtmlColorParser.parseColor(attributeValue));
                    }
                    catch (IllegalArgumentException e) {
                        Log.w((String)TAG, (String)("failed parsing background value: '" + attributeValue + "'"));
                    }
                    continue block54;
                }
                case "color": {
                    style = this.createIfNull(style);
                    try {
                        style.setFontColor(TtmlColorParser.parseColor(attributeValue));
                    }
                    catch (IllegalArgumentException e) {
                        Log.w((String)TAG, (String)("failed parsing color value: '" + attributeValue + "'"));
                    }
                    continue block54;
                }
                case "fontFamily": {
                    style = this.createIfNull(style).setFontFamily(attributeValue);
                    continue block54;
                }
                case "fontSize": {
                    try {
                        style = this.createIfNull(style);
                        TtmlParser.parseFontSize(attributeValue, style);
                    }
                    catch (ParserException e) {
                        Log.w((String)TAG, (String)("failed parsing fontSize value: '" + attributeValue + "'"));
                    }
                    continue block54;
                }
                case "fontWeight": {
                    style = this.createIfNull(style).setBold("bold".equalsIgnoreCase(attributeValue));
                    continue block54;
                }
                case "fontStyle": {
                    style = this.createIfNull(style).setItalic("italic".equalsIgnoreCase(attributeValue));
                    continue block54;
                }
                case "textAlign": {
                    switch (Util.toLowerInvariant(attributeValue)) {
                        case "left": {
                            style = this.createIfNull(style).setTextAlign(Layout.Alignment.ALIGN_NORMAL);
                            break;
                        }
                        case "start": {
                            style = this.createIfNull(style).setTextAlign(Layout.Alignment.ALIGN_NORMAL);
                            break;
                        }
                        case "right": {
                            style = this.createIfNull(style).setTextAlign(Layout.Alignment.ALIGN_OPPOSITE);
                            break;
                        }
                        case "end": {
                            style = this.createIfNull(style).setTextAlign(Layout.Alignment.ALIGN_OPPOSITE);
                            break;
                        }
                        case "center": {
                            style = this.createIfNull(style).setTextAlign(Layout.Alignment.ALIGN_CENTER);
                        }
                    }
                    continue block54;
                }
                case "textDecoration": {
                    switch (Util.toLowerInvariant(attributeValue)) {
                        case "linethrough": {
                            style = this.createIfNull(style).setLinethrough(true);
                            break;
                        }
                        case "nolinethrough": {
                            style = this.createIfNull(style).setLinethrough(false);
                            break;
                        }
                        case "underline": {
                            style = this.createIfNull(style).setUnderline(true);
                            break;
                        }
                        case "nounderline": {
                            style = this.createIfNull(style).setUnderline(false);
                        }
                    }
                    continue block54;
                }
            }
        }
        return style;
    }

    private TtmlStyle createIfNull(TtmlStyle style) {
        return style == null ? new TtmlStyle() : style;
    }

    private TtmlNode parseNode(XmlPullParser parser, TtmlNode parent, Map<String, TtmlRegion> regionMap, FrameAndTickRate frameAndTickRate) throws ParserException {
        long duration = 0L;
        long startTime = -1L;
        long endTime = -1L;
        String regionId = "";
        String[] styleIds = null;
        int attributeCount = parser.getAttributeCount();
        TtmlStyle style = this.parseStyleAttributes(parser, null);
        for (int i = 0; i < attributeCount; ++i) {
            String attr2 = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (ATTR_BEGIN.equals(attr2)) {
                startTime = TtmlParser.parseTimeExpression(value, frameAndTickRate);
                continue;
            }
            if (ATTR_END.equals(attr2)) {
                endTime = TtmlParser.parseTimeExpression(value, frameAndTickRate);
                continue;
            }
            if (ATTR_DURATION.equals(attr2)) {
                duration = TtmlParser.parseTimeExpression(value, frameAndTickRate);
                continue;
            }
            if (ATTR_STYLE.equals(attr2)) {
                String[] ids = this.parseStyleIds(value);
                if (ids.length <= 0) continue;
                styleIds = ids;
                continue;
            }
            if (!ATTR_REGION.equals(attr2) || !regionMap.containsKey(value)) continue;
            regionId = value;
        }
        if (parent != null && parent.startTimeUs != -1L) {
            if (startTime != -1L) {
                startTime += parent.startTimeUs;
            }
            if (endTime != -1L) {
                endTime += parent.startTimeUs;
            }
        }
        if (endTime == -1L) {
            if (duration > 0L) {
                endTime = startTime + duration;
            } else if (parent != null && parent.endTimeUs != -1L) {
                endTime = parent.endTimeUs;
            }
        }
        return TtmlNode.buildNode(parser.getName(), startTime, endTime, style, styleIds, regionId);
    }

    private static boolean isSupportedTag(String tag) {
        return tag.equals("tt") || tag.equals("head") || tag.equals("body") || tag.equals("div") || tag.equals("p") || tag.equals("span") || tag.equals("br") || tag.equals(ATTR_STYLE) || tag.equals("styling") || tag.equals("layout") || tag.equals(ATTR_REGION) || tag.equals("metadata") || tag.equals("smpte:image") || tag.equals("smpte:data") || tag.equals("smpte:information");
    }

    private static void parseFontSize(String expression, TtmlStyle out) throws ParserException {
        Matcher matcher;
        String[] expressions = expression.split("\\s+");
        if (expressions.length == 1) {
            matcher = FONT_SIZE.matcher(expression);
        } else if (expressions.length == 2) {
            matcher = FONT_SIZE.matcher(expressions[1]);
            Log.w((String)TAG, (String)"Multiple values in fontSize attribute. Picking the second value for vertical font size and ignoring the first.");
        } else {
            throw new ParserException("Invalid number of entries for fontSize: " + expressions.length + ".");
        }
        if (matcher.matches()) {
            String unit;
            switch (unit = matcher.group(3)) {
                case "px": {
                    out.setFontSizeUnit(1);
                    break;
                }
                case "em": {
                    out.setFontSizeUnit(2);
                    break;
                }
                case "%": {
                    out.setFontSizeUnit(3);
                    break;
                }
                default: {
                    throw new ParserException("Invalid unit for fontSize: '" + unit + "'.");
                }
            }
        } else {
            throw new ParserException("Invalid expression for fontSize: '" + expression + "'.");
        }
        out.setFontSize(Float.valueOf(matcher.group(1)).floatValue());
    }

    private static long parseTimeExpression(String time, FrameAndTickRate frameAndTickRate) throws ParserException {
        Matcher matcher = CLOCK_TIME.matcher(time);
        if (matcher.matches()) {
            String hours = matcher.group(1);
            double durationSeconds = Long.parseLong(hours) * 3600L;
            String minutes = matcher.group(2);
            durationSeconds += (double)(Long.parseLong(minutes) * 60L);
            String seconds = matcher.group(3);
            durationSeconds += (double)Long.parseLong(seconds);
            String fraction = matcher.group(4);
            durationSeconds += fraction != null ? Double.parseDouble(fraction) : 0.0;
            String frames = matcher.group(5);
            durationSeconds += frames != null ? (double)((float)Long.parseLong(frames) / frameAndTickRate.effectiveFrameRate) : 0.0;
            String subframes = matcher.group(6);
            return (long)((durationSeconds += subframes != null ? (double)Long.parseLong(subframes) / (double)frameAndTickRate.subFrameRate / (double)frameAndTickRate.effectiveFrameRate : 0.0) * 1000000.0);
        }
        matcher = OFFSET_TIME.matcher(time);
        if (matcher.matches()) {
            String timeValue = matcher.group(1);
            double offsetSeconds = Double.parseDouble(timeValue);
            String unit = matcher.group(2);
            if (unit.equals("h")) {
                offsetSeconds *= 3600.0;
            } else if (unit.equals("m")) {
                offsetSeconds *= 60.0;
            } else if (!unit.equals("s")) {
                if (unit.equals("ms")) {
                    offsetSeconds /= 1000.0;
                } else if (unit.equals("f")) {
                    offsetSeconds /= (double)frameAndTickRate.effectiveFrameRate;
                } else if (unit.equals("t")) {
                    offsetSeconds /= (double)frameAndTickRate.tickRate;
                }
            }
            return (long)(offsetSeconds * 1000000.0);
        }
        throw new ParserException("Malformed time expression: " + time);
    }

    private static final class FrameAndTickRate {
        final float effectiveFrameRate;
        final int subFrameRate;
        final int tickRate;

        FrameAndTickRate(float effectiveFrameRate, int subFrameRate, int tickRate) {
            this.effectiveFrameRate = effectiveFrameRate;
            this.subFrameRate = subFrameRate;
            this.tickRate = tickRate;
        }
    }
}

