/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.ttml;

import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.Subtitle;
import com.google.android.exoplayer.text.ttml.TtmlNode;
import com.google.android.exoplayer.text.ttml.TtmlRegion;
import com.google.android.exoplayer.text.ttml.TtmlStyle;
import com.google.android.exoplayer.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class TtmlSubtitle
implements Subtitle {
    private final TtmlNode root;
    private final long[] eventTimesUs;
    private final Map<String, TtmlStyle> globalStyles;
    private final Map<String, TtmlRegion> regionMap;

    public TtmlSubtitle(TtmlNode root, Map<String, TtmlStyle> globalStyles, Map<String, TtmlRegion> regionMap) {
        this.root = root;
        this.regionMap = regionMap;
        this.globalStyles = globalStyles != null ? Collections.unmodifiableMap(globalStyles) : Collections.emptyMap();
        this.eventTimesUs = root.getEventTimesUs();
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        int index = Util.binarySearchCeil(this.eventTimesUs, timeUs, false, false);
        return index < this.eventTimesUs.length ? index : -1;
    }

    @Override
    public int getEventTimeCount() {
        return this.eventTimesUs.length;
    }

    @Override
    public long getEventTime(int index) {
        return this.eventTimesUs[index];
    }

    @Override
    public long getLastEventTime() {
        return this.eventTimesUs.length == 0 ? -1L : this.eventTimesUs[this.eventTimesUs.length - 1];
    }

    TtmlNode getRoot() {
        return this.root;
    }

    @Override
    public List<Cue> getCues(long timeUs) {
        return this.root.getCues(timeUs, this.globalStyles, this.regionMap);
    }

    Map<String, TtmlStyle> getGlobalStyles() {
        return this.globalStyles;
    }
}

