/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.tx3g;

import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.Subtitle;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.tx3g.Tx3gSubtitle;
import com.google.android.exoplayer.util.ParsableByteArray;

public final class Tx3gParser
implements SubtitleParser {
    private final ParsableByteArray parsableByteArray = new ParsableByteArray();

    @Override
    public boolean canParse(String mimeType) {
        return "application/x-quicktime-tx3g".equals(mimeType);
    }

    @Override
    public Subtitle parse(byte[] bytes, int offset, int length) {
        this.parsableByteArray.reset(bytes, length);
        int textLength = this.parsableByteArray.readUnsignedShort();
        if (textLength == 0) {
            return Tx3gSubtitle.EMPTY;
        }
        String cueText = this.parsableByteArray.readString(textLength);
        return new Tx3gSubtitle(new Cue(cueText));
    }
}

