/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.tx3g;

import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.Subtitle;
import com.google.android.exoplayer.util.Assertions;
import java.util.Collections;
import java.util.List;

final class Tx3gSubtitle
implements Subtitle {
    public static final Tx3gSubtitle EMPTY = new Tx3gSubtitle();
    private final List<Cue> cues;

    public Tx3gSubtitle(Cue cue) {
        this.cues = Collections.singletonList(cue);
    }

    private Tx3gSubtitle() {
        this.cues = Collections.emptyList();
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        return timeUs < 0L ? 0 : -1;
    }

    @Override
    public int getEventTimeCount() {
        return 1;
    }

    @Override
    public long getEventTime(int index) {
        Assertions.checkArgument(index == 0);
        return 0L;
    }

    @Override
    public long getLastEventTime() {
        return 0L;
    }

    @Override
    public List<Cue> getCues(long timeUs) {
        return timeUs >= 0L ? this.cues : Collections.emptyList();
    }
}

