/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.webvtt;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.webvtt.Mp4WebvttSubtitle;
import com.google.android.exoplayer.text.webvtt.WebvttCue;
import com.google.android.exoplayer.text.webvtt.WebvttCueParser;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.util.ArrayList;

public final class Mp4WebvttParser
implements SubtitleParser {
    private static final int BOX_HEADER_SIZE = 8;
    private static final int TYPE_payl = Util.getIntegerCodeForString("payl");
    private static final int TYPE_sttg = Util.getIntegerCodeForString("sttg");
    private static final int TYPE_vttc = Util.getIntegerCodeForString("vttc");
    private final ParsableByteArray sampleData = new ParsableByteArray();
    private final WebvttCue.Builder builder = new WebvttCue.Builder();

    @Override
    public boolean canParse(String mimeType) {
        return "application/x-mp4vtt".equals(mimeType);
    }

    @Override
    public Mp4WebvttSubtitle parse(byte[] bytes, int offset, int length) throws ParserException {
        this.sampleData.reset(bytes, offset + length);
        this.sampleData.setPosition(offset);
        ArrayList<Cue> resultingCueList = new ArrayList<Cue>();
        while (this.sampleData.bytesLeft() > 0) {
            if (this.sampleData.bytesLeft() < 8) {
                throw new ParserException("Incomplete Mp4Webvtt Top Level box header found.");
            }
            int boxSize = this.sampleData.readInt();
            int boxType = this.sampleData.readInt();
            if (boxType == TYPE_vttc) {
                resultingCueList.add(Mp4WebvttParser.parseVttCueBox(this.sampleData, this.builder, boxSize - 8));
                continue;
            }
            this.sampleData.skipBytes(boxSize - 8);
        }
        return new Mp4WebvttSubtitle(resultingCueList);
    }

    private static Cue parseVttCueBox(ParsableByteArray sampleData, WebvttCue.Builder builder, int remainingCueBoxBytes) throws ParserException {
        builder.reset();
        while (remainingCueBoxBytes > 0) {
            if (remainingCueBoxBytes < 8) {
                throw new ParserException("Incomplete vtt cue box header found.");
            }
            int boxSize = sampleData.readInt();
            int boxType = sampleData.readInt();
            remainingCueBoxBytes -= 8;
            int payloadLength = boxSize - 8;
            String boxPayload = new String(sampleData.data, sampleData.getPosition(), payloadLength);
            sampleData.skipBytes(payloadLength);
            remainingCueBoxBytes -= payloadLength;
            if (boxType == TYPE_sttg) {
                WebvttCueParser.parseCueSettingsList(boxPayload, builder);
                continue;
            }
            if (boxType != TYPE_payl) continue;
            WebvttCueParser.parseCueText(boxPayload.trim(), builder);
        }
        return builder.build();
    }
}

