/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.webvtt;

import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.util.Log;
import com.google.android.exoplayer.text.webvtt.WebvttCue;
import com.google.android.exoplayer.text.webvtt.WebvttParserUtil;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WebvttCueParser {
    public static final Pattern CUE_HEADER_PATTERN = Pattern.compile("^(\\S+)\\s+-->\\s+(\\S+)(.*)?$");
    private static final Pattern COMMENT = Pattern.compile("^NOTE(( |\t).*)?$");
    private static final Pattern CUE_SETTING_PATTERN = Pattern.compile("(\\S+?):(\\S+)");
    private static final char CHAR_LESS_THAN = '<';
    private static final char CHAR_GREATER_THAN = '>';
    private static final char CHAR_SLASH = '/';
    private static final char CHAR_AMPERSAND = '&';
    private static final char CHAR_SEMI_COLON = ';';
    private static final char CHAR_SPACE = ' ';
    private static final String SPACE = " ";
    private static final String ENTITY_LESS_THAN = "lt";
    private static final String ENTITY_GREATER_THAN = "gt";
    private static final String ENTITY_AMPERSAND = "amp";
    private static final String ENTITY_NON_BREAK_SPACE = "nbsp";
    private static final String TAG_BOLD = "b";
    private static final String TAG_ITALIC = "i";
    private static final String TAG_UNDERLINE = "u";
    private static final String TAG_CLASS = "c";
    private static final String TAG_VOICE = "v";
    private static final String TAG_LANG = "lang";
    private static final int STYLE_BOLD = 1;
    private static final int STYLE_ITALIC = 2;
    private static final String TAG = "WebvttCueParser";
    private final StringBuilder textBuilder = new StringBuilder();

    boolean parseNextValidCue(ParsableByteArray webvttData, WebvttCue.Builder builder) {
        Matcher cueHeaderMatcher;
        while ((cueHeaderMatcher = WebvttCueParser.findNextCueHeader(webvttData)) != null) {
            if (!WebvttCueParser.parseCue(cueHeaderMatcher, webvttData, builder, this.textBuilder)) continue;
            return true;
        }
        return false;
    }

    static void parseCueSettingsList(String cueSettingsList, WebvttCue.Builder builder) {
        Matcher cueSettingMatcher = CUE_SETTING_PATTERN.matcher(cueSettingsList);
        while (cueSettingMatcher.find()) {
            String name = cueSettingMatcher.group(1);
            String value = cueSettingMatcher.group(2);
            try {
                if ("line".equals(name)) {
                    WebvttCueParser.parseLineAttribute(value, builder);
                    continue;
                }
                if ("align".equals(name)) {
                    builder.setTextAlignment(WebvttCueParser.parseTextAlignment(value));
                    continue;
                }
                if ("position".equals(name)) {
                    WebvttCueParser.parsePositionAttribute(value, builder);
                    continue;
                }
                if ("size".equals(name)) {
                    builder.setWidth(WebvttParserUtil.parsePercentage(value));
                    continue;
                }
                Log.w((String)TAG, (String)("Unknown cue setting " + name + ":" + value));
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)("Skipping bad cue setting: " + cueSettingMatcher.group()));
            }
        }
    }

    public static Matcher findNextCueHeader(ParsableByteArray input) {
        String line;
        while ((line = input.readLine()) != null) {
            if (COMMENT.matcher(line).matches()) {
                while ((line = input.readLine()) != null && !line.isEmpty()) {
                }
                continue;
            }
            Matcher cueHeaderMatcher = CUE_HEADER_PATTERN.matcher(line);
            if (!cueHeaderMatcher.matches()) continue;
            return cueHeaderMatcher;
        }
        return null;
    }

    static void parseCueText(String markup, WebvttCue.Builder builder) {
        SpannableStringBuilder spannedText = new SpannableStringBuilder();
        Stack<StartTag> startTagStack = new Stack<StartTag>();
        int pos = 0;
        block4: while (pos < markup.length()) {
            char curr = markup.charAt(pos);
            block0 : switch (curr) {
                case '<': {
                    boolean isVoidTag;
                    int ltPos;
                    if (pos + 1 >= markup.length()) {
                        ++pos;
                        break;
                    }
                    boolean isClosingTag = markup.charAt((ltPos = pos) + 1) == '/';
                    String[] tagTokens = WebvttCueParser.tokenizeTag(markup.substring(ltPos + (isClosingTag ? 2 : 1), (isVoidTag = markup.charAt((pos = WebvttCueParser.findEndOfTag(markup, ltPos + 1)) - 2) == '/') ? pos - 2 : pos - 1));
                    if (tagTokens == null || !WebvttCueParser.isSupportedTag(tagTokens[0])) continue block4;
                    if (isClosingTag) {
                        while (!startTagStack.isEmpty()) {
                            StartTag startTag = (StartTag)startTagStack.pop();
                            WebvttCueParser.applySpansForTag(startTag, spannedText);
                            if (!startTag.name.equals(tagTokens[0])) continue;
                            break block0;
                        }
                        continue block4;
                    }
                    if (isVoidTag) continue block4;
                    startTagStack.push(new StartTag(tagTokens[0], spannedText.length()));
                    break;
                }
                case '&': {
                    int entityEnd;
                    int semiColonEnd = markup.indexOf(59, pos + 1);
                    int spaceEnd = markup.indexOf(32, pos + 1);
                    int n = semiColonEnd == -1 ? spaceEnd : (entityEnd = spaceEnd == -1 ? semiColonEnd : Math.min(semiColonEnd, spaceEnd));
                    if (entityEnd != -1) {
                        WebvttCueParser.applyEntity(markup.substring(pos + 1, entityEnd), spannedText);
                        if (entityEnd == spaceEnd) {
                            spannedText.append((CharSequence)SPACE);
                        }
                        pos = entityEnd + 1;
                        break;
                    }
                    spannedText.append(curr);
                    ++pos;
                    break;
                }
                default: {
                    spannedText.append(curr);
                    ++pos;
                }
            }
        }
        while (!startTagStack.isEmpty()) {
            WebvttCueParser.applySpansForTag((StartTag)startTagStack.pop(), spannedText);
        }
        builder.setText((CharSequence)spannedText);
    }

    private static boolean parseCue(Matcher cueHeaderMatcher, ParsableByteArray webvttData, WebvttCue.Builder builder, StringBuilder textBuilder) {
        String line;
        try {
            builder.setStartTime(WebvttParserUtil.parseTimestampUs(cueHeaderMatcher.group(1))).setEndTime(WebvttParserUtil.parseTimestampUs(cueHeaderMatcher.group(2)));
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)("Skipping cue with bad header: " + cueHeaderMatcher.group()));
            return false;
        }
        WebvttCueParser.parseCueSettingsList(cueHeaderMatcher.group(3), builder);
        textBuilder.setLength(0);
        while ((line = webvttData.readLine()) != null && !line.isEmpty()) {
            if (textBuilder.length() > 0) {
                textBuilder.append("\n");
            }
            textBuilder.append(line.trim());
        }
        WebvttCueParser.parseCueText(textBuilder.toString(), builder);
        return true;
    }

    private static void parseLineAttribute(String s, WebvttCue.Builder builder) throws NumberFormatException {
        int commaPosition = s.indexOf(44);
        if (commaPosition != -1) {
            builder.setLineAnchor(WebvttCueParser.parsePositionAnchor(s.substring(commaPosition + 1)));
            s = s.substring(0, commaPosition);
        } else {
            builder.setLineAnchor(Integer.MIN_VALUE);
        }
        if (s.endsWith("%")) {
            builder.setLine(WebvttParserUtil.parsePercentage(s)).setLineType(0);
        } else {
            builder.setLine(Integer.parseInt(s)).setLineType(1);
        }
    }

    private static void parsePositionAttribute(String s, WebvttCue.Builder builder) throws NumberFormatException {
        int commaPosition = s.indexOf(44);
        if (commaPosition != -1) {
            builder.setPositionAnchor(WebvttCueParser.parsePositionAnchor(s.substring(commaPosition + 1)));
            s = s.substring(0, commaPosition);
        } else {
            builder.setPositionAnchor(Integer.MIN_VALUE);
        }
        builder.setPosition(WebvttParserUtil.parsePercentage(s));
    }

    private static int parsePositionAnchor(String s) {
        switch (s) {
            case "start": {
                return 0;
            }
            case "center": 
            case "middle": {
                return 1;
            }
            case "end": {
                return 2;
            }
        }
        Log.w((String)TAG, (String)("Invalid anchor value: " + s));
        return Integer.MIN_VALUE;
    }

    private static Layout.Alignment parseTextAlignment(String s) {
        switch (s) {
            case "start": 
            case "left": {
                return Layout.Alignment.ALIGN_NORMAL;
            }
            case "center": 
            case "middle": {
                return Layout.Alignment.ALIGN_CENTER;
            }
            case "end": 
            case "right": {
                return Layout.Alignment.ALIGN_OPPOSITE;
            }
        }
        Log.w((String)TAG, (String)("Invalid alignment value: " + s));
        return null;
    }

    private static int findEndOfTag(String markup, int startPos) {
        int idx = markup.indexOf(62, startPos);
        return idx == -1 ? markup.length() : idx + 1;
    }

    private static void applyEntity(String entity, SpannableStringBuilder spannedText) {
        switch (entity) {
            case "lt": {
                spannedText.append('<');
                break;
            }
            case "gt": {
                spannedText.append('>');
                break;
            }
            case "nbsp": {
                spannedText.append(' ');
                break;
            }
            case "amp": {
                spannedText.append('&');
                break;
            }
            default: {
                Log.w((String)TAG, (String)("ignoring unsupported entity: '&" + entity + ";'"));
            }
        }
    }

    private static boolean isSupportedTag(String tagName) {
        switch (tagName) {
            case "b": 
            case "c": 
            case "i": 
            case "lang": 
            case "u": 
            case "v": {
                return true;
            }
        }
        return false;
    }

    private static void applySpansForTag(StartTag startTag, SpannableStringBuilder spannedText) {
        switch (startTag.name) {
            case "b": {
                spannedText.setSpan((Object)new StyleSpan(1), startTag.position, spannedText.length(), 33);
                return;
            }
            case "i": {
                spannedText.setSpan((Object)new StyleSpan(2), startTag.position, spannedText.length(), 33);
                return;
            }
            case "u": {
                spannedText.setSpan((Object)new UnderlineSpan(), startTag.position, spannedText.length(), 33);
                return;
            }
        }
    }

    private static String[] tokenizeTag(String fullTagExpression) {
        if ((fullTagExpression = fullTagExpression.replace("\\s+", SPACE).trim()).length() == 0) {
            return null;
        }
        if (fullTagExpression.contains(SPACE)) {
            fullTagExpression = fullTagExpression.substring(0, fullTagExpression.indexOf(SPACE));
        }
        return fullTagExpression.split("\\.");
    }

    private static final class StartTag {
        public final String name;
        public final int position;

        public StartTag(String name, int position) {
            this.position = position;
            this.name = name;
        }
    }
}

