/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.webvtt;

import android.text.TextUtils;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.webvtt.WebvttCue;
import com.google.android.exoplayer.text.webvtt.WebvttCueParser;
import com.google.android.exoplayer.text.webvtt.WebvttParserUtil;
import com.google.android.exoplayer.text.webvtt.WebvttSubtitle;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.util.ArrayList;

public final class WebvttParser
implements SubtitleParser {
    private final WebvttCueParser cueParser = new WebvttCueParser();
    private final ParsableByteArray parsableWebvttData = new ParsableByteArray();
    private final WebvttCue.Builder webvttCueBuilder = new WebvttCue.Builder();

    @Override
    public final boolean canParse(String mimeType) {
        return "text/vtt".equals(mimeType);
    }

    @Override
    public final WebvttSubtitle parse(byte[] bytes, int offset, int length) throws ParserException {
        this.parsableWebvttData.reset(bytes, offset + length);
        this.parsableWebvttData.setPosition(offset);
        this.webvttCueBuilder.reset();
        WebvttParserUtil.validateWebvttHeaderLine(this.parsableWebvttData);
        while (!TextUtils.isEmpty((CharSequence)this.parsableWebvttData.readLine())) {
        }
        ArrayList<WebvttCue> subtitles = new ArrayList<WebvttCue>();
        while (this.cueParser.parseNextValidCue(this.parsableWebvttData, this.webvttCueBuilder)) {
            subtitles.add(this.webvttCueBuilder.build());
            this.webvttCueBuilder.reset();
        }
        return new WebvttSubtitle(subtitles);
    }
}

