/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.content.Context;
import android.content.res.AssetManager;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class AssetDataSource
implements UriDataSource {
    private final AssetManager assetManager;
    private final TransferListener listener;
    private String uriString;
    private InputStream inputStream;
    private long bytesRemaining;
    private boolean opened;

    public AssetDataSource(Context context) {
        this(context, null);
    }

    public AssetDataSource(Context context, TransferListener listener) {
        this.assetManager = context.getAssets();
        this.listener = listener;
    }

    @Override
    public long open(DataSpec dataSpec) throws AssetDataSourceException {
        try {
            this.uriString = dataSpec.uri.toString();
            String path = dataSpec.uri.getPath();
            if (path.startsWith("/android_asset/")) {
                path = path.substring(15);
            } else if (path.startsWith("/")) {
                path = path.substring(1);
            }
            this.uriString = dataSpec.uri.toString();
            this.inputStream = this.assetManager.open(path, 1);
            long skipped = this.inputStream.skip(dataSpec.position);
            if (skipped < dataSpec.position) {
                throw new EOFException();
            }
            if (dataSpec.length != -1L) {
                this.bytesRemaining = dataSpec.length;
            } else {
                this.bytesRemaining = this.inputStream.available();
                if (this.bytesRemaining == Integer.MAX_VALUE) {
                    this.bytesRemaining = -1L;
                }
            }
        }
        catch (IOException e) {
            throw new AssetDataSourceException(e);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart();
        }
        return this.bytesRemaining;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws AssetDataSourceException {
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int bytesRead = 0;
        try {
            int bytesToRead = this.bytesRemaining == -1L ? readLength : (int)Math.min(this.bytesRemaining, (long)readLength);
            bytesRead = this.inputStream.read(buffer, offset, bytesToRead);
        }
        catch (IOException e) {
            throw new AssetDataSourceException(e);
        }
        if (bytesRead > 0) {
            if (this.bytesRemaining != -1L) {
                this.bytesRemaining -= (long)bytesRead;
            }
            if (this.listener != null) {
                this.listener.onBytesTransferred(bytesRead);
            }
        }
        return bytesRead;
    }

    @Override
    public String getUri() {
        return this.uriString;
    }

    @Override
    public void close() throws AssetDataSourceException {
        this.uriString = null;
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                throw new AssetDataSourceException(e);
            }
            finally {
                this.inputStream = null;
                if (this.opened) {
                    this.opened = false;
                    if (this.listener != null) {
                        this.listener.onTransferEnd();
                    }
                }
            }
        }
    }

    public static final class AssetDataSourceException
    extends IOException {
        public AssetDataSourceException(IOException cause) {
            super(cause);
        }
    }
}

