/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;

public final class ByteArrayDataSource
implements DataSource {
    private final byte[] data;
    private int readPosition;
    private int remainingBytes;

    public ByteArrayDataSource(byte[] data) {
        Assertions.checkNotNull(data);
        Assertions.checkArgument(data.length > 0);
        this.data = data;
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        this.readPosition = (int)dataSpec.position;
        this.remainingBytes = (int)(dataSpec.length == -1L ? (long)this.data.length - dataSpec.position : dataSpec.length);
        if (this.remainingBytes <= 0 || this.readPosition + this.remainingBytes > this.data.length) {
            throw new IOException("Unsatisfiable range: [" + this.readPosition + ", " + dataSpec.length + "], length: " + this.data.length);
        }
        return this.remainingBytes;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.remainingBytes == 0) {
            return -1;
        }
        length = Math.min(length, this.remainingBytes);
        System.arraycopy(this.data, this.readPosition, buffer, offset, length);
        this.readPosition += length;
        this.remainingBytes -= length;
        return length;
    }
}

