/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ContentDataSource
implements UriDataSource {
    private final ContentResolver resolver;
    private final TransferListener listener;
    private AssetFileDescriptor assetFileDescriptor;
    private InputStream inputStream;
    private String uriString;
    private long bytesRemaining;
    private boolean opened;

    public ContentDataSource(Context context) {
        this(context, null);
    }

    public ContentDataSource(Context context, TransferListener listener) {
        this.resolver = context.getContentResolver();
        this.listener = listener;
    }

    @Override
    public long open(DataSpec dataSpec) throws ContentDataSourceException {
        try {
            this.uriString = dataSpec.uri.toString();
            this.assetFileDescriptor = this.resolver.openAssetFileDescriptor(dataSpec.uri, "r");
            this.inputStream = new FileInputStream(this.assetFileDescriptor.getFileDescriptor());
            long skipped = this.inputStream.skip(dataSpec.position);
            if (skipped < dataSpec.position) {
                throw new EOFException();
            }
            if (dataSpec.length != -1L) {
                this.bytesRemaining = dataSpec.length;
            } else {
                this.bytesRemaining = this.inputStream.available();
                if (this.bytesRemaining == 0L) {
                    this.bytesRemaining = -1L;
                }
            }
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart();
        }
        return this.bytesRemaining;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws ContentDataSourceException {
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int bytesRead = 0;
        try {
            int bytesToRead = this.bytesRemaining == -1L ? readLength : (int)Math.min(this.bytesRemaining, (long)readLength);
            bytesRead = this.inputStream.read(buffer, offset, bytesToRead);
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e);
        }
        if (bytesRead > 0) {
            if (this.bytesRemaining != -1L) {
                this.bytesRemaining -= (long)bytesRead;
            }
            if (this.listener != null) {
                this.listener.onBytesTransferred(bytesRead);
            }
        }
        return bytesRead;
    }

    @Override
    public String getUri() {
        return this.uriString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws ContentDataSourceException {
        this.uriString = null;
        try {
            if (this.inputStream == null) return;
            this.inputStream.close();
            return;
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e);
        }
        finally {
            this.inputStream = null;
            try {
                if (this.assetFileDescriptor != null) {
                    this.assetFileDescriptor.close();
                }
            }
            catch (IOException e) {
                throw new ContentDataSourceException(e);
            }
            finally {
                this.assetFileDescriptor = null;
                if (this.opened) {
                    this.opened = false;
                    if (this.listener != null) {
                        this.listener.onTransferEnd();
                    }
                }
            }
        }
    }

    public static class ContentDataSourceException
    extends IOException {
        public ContentDataSourceException(IOException cause) {
            super(cause);
        }
    }
}

