/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.Allocation;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.util.Arrays;

public final class DefaultAllocator
implements Allocator {
    private static final int AVAILABLE_EXTRA_CAPACITY = 100;
    private final int individualAllocationSize;
    private final byte[] initialAllocationBlock;
    private int allocatedCount;
    private int availableCount;
    private Allocation[] availableAllocations;

    public DefaultAllocator(int individualAllocationSize) {
        this(individualAllocationSize, 0);
    }

    public DefaultAllocator(int individualAllocationSize, int initialAllocationCount) {
        Assertions.checkArgument(individualAllocationSize > 0);
        Assertions.checkArgument(initialAllocationCount >= 0);
        this.individualAllocationSize = individualAllocationSize;
        this.availableCount = initialAllocationCount;
        this.availableAllocations = new Allocation[initialAllocationCount + 100];
        if (initialAllocationCount > 0) {
            this.initialAllocationBlock = new byte[initialAllocationCount * individualAllocationSize];
            for (int i = 0; i < initialAllocationCount; ++i) {
                int allocationOffset = i * individualAllocationSize;
                this.availableAllocations[i] = new Allocation(this.initialAllocationBlock, allocationOffset);
            }
        } else {
            this.initialAllocationBlock = null;
        }
    }

    @Override
    public synchronized Allocation allocate() {
        Allocation allocation;
        ++this.allocatedCount;
        if (this.availableCount > 0) {
            allocation = this.availableAllocations[--this.availableCount];
            this.availableAllocations[this.availableCount] = null;
        } else {
            allocation = new Allocation(new byte[this.individualAllocationSize], 0);
        }
        return allocation;
    }

    @Override
    public synchronized void release(Allocation allocation) {
        Assertions.checkArgument(allocation.data == this.initialAllocationBlock || allocation.data.length == this.individualAllocationSize);
        --this.allocatedCount;
        if (this.availableCount == this.availableAllocations.length) {
            this.availableAllocations = Arrays.copyOf(this.availableAllocations, this.availableAllocations.length * 2);
        }
        this.availableAllocations[this.availableCount++] = allocation;
        this.notifyAll();
    }

    @Override
    public synchronized void release(Allocation[] allocations) {
        if (this.availableCount + allocations.length >= this.availableAllocations.length) {
            this.availableAllocations = Arrays.copyOf(this.availableAllocations, Math.max(this.availableAllocations.length * 2, this.availableCount + allocations.length));
        }
        for (Allocation allocation : allocations) {
            Assertions.checkArgument(allocation.data == this.initialAllocationBlock || allocation.data.length == this.individualAllocationSize);
            this.availableAllocations[this.availableCount++] = allocation;
        }
        this.allocatedCount -= allocations.length;
        this.notifyAll();
    }

    @Override
    public synchronized void trim(int targetSize) {
        int targetAllocationCount = Util.ceilDivide(targetSize, this.individualAllocationSize);
        int targetAvailableCount = Math.max(0, targetAllocationCount - this.allocatedCount);
        if (targetAvailableCount >= this.availableCount) {
            return;
        }
        if (this.initialAllocationBlock != null) {
            int lowIndex = 0;
            int highIndex = this.availableCount - 1;
            while (lowIndex <= highIndex) {
                Allocation lowAllocation = this.availableAllocations[lowIndex];
                if (lowAllocation.data == this.initialAllocationBlock) {
                    ++lowIndex;
                    continue;
                }
                Allocation highAllocation = this.availableAllocations[highIndex];
                if (highAllocation.data != this.initialAllocationBlock) {
                    --highIndex;
                    continue;
                }
                this.availableAllocations[lowIndex++] = highAllocation;
                this.availableAllocations[highIndex--] = lowAllocation;
            }
            if ((targetAvailableCount = Math.max(targetAvailableCount, lowIndex)) >= this.availableCount) {
                return;
            }
        }
        Arrays.fill(this.availableAllocations, targetAvailableCount, this.availableCount, null);
        this.availableCount = targetAvailableCount;
    }

    @Override
    public synchronized int getTotalBytesAllocated() {
        return this.allocatedCount * this.individualAllocationSize;
    }

    @Override
    public synchronized void blockWhileTotalBytesAllocatedExceeds(int limit) throws InterruptedException {
        while (this.getTotalBytesAllocated() > limit) {
            this.wait();
        }
    }

    @Override
    public int getIndividualAllocationLength() {
        return this.individualAllocationSize;
    }
}

