/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.text.TextUtils;
import android.util.Log;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.HttpDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Predicate;
import com.google.android.exoplayer.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultHttpDataSource
implements HttpDataSource {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 8000;
    public static final int DEFAULT_READ_TIMEOUT_MILLIS = 8000;
    private static final int MAX_REDIRECTS = 20;
    private static final String TAG = "DefaultHttpDataSource";
    private static final Pattern CONTENT_RANGE_HEADER = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+)$");
    private static final AtomicReference<byte[]> skipBufferReference = new AtomicReference();
    private final boolean allowCrossProtocolRedirects;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final String userAgent;
    private final Predicate<String> contentTypePredicate;
    private final HashMap<String, String> requestProperties;
    private final TransferListener listener;
    private DataSpec dataSpec;
    private HttpURLConnection connection;
    private InputStream inputStream;
    private boolean opened;
    private long bytesToSkip;
    private long bytesToRead;
    private long bytesSkipped;
    private long bytesRead;

    public DefaultHttpDataSource(String userAgent, Predicate<String> contentTypePredicate) {
        this(userAgent, contentTypePredicate, null);
    }

    public DefaultHttpDataSource(String userAgent, Predicate<String> contentTypePredicate, TransferListener listener) {
        this(userAgent, contentTypePredicate, listener, 8000, 8000);
    }

    public DefaultHttpDataSource(String userAgent, Predicate<String> contentTypePredicate, TransferListener listener, int connectTimeoutMillis, int readTimeoutMillis) {
        this(userAgent, contentTypePredicate, listener, connectTimeoutMillis, readTimeoutMillis, false);
    }

    public DefaultHttpDataSource(String userAgent, Predicate<String> contentTypePredicate, TransferListener listener, int connectTimeoutMillis, int readTimeoutMillis, boolean allowCrossProtocolRedirects) {
        this.userAgent = Assertions.checkNotEmpty(userAgent);
        this.contentTypePredicate = contentTypePredicate;
        this.listener = listener;
        this.requestProperties = new HashMap();
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.allowCrossProtocolRedirects = allowCrossProtocolRedirects;
    }

    @Override
    public String getUri() {
        return this.connection == null ? null : this.connection.getURL().toString();
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        return this.connection == null ? null : this.connection.getHeaderFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestProperty(String name, String value) {
        Assertions.checkNotNull(name);
        Assertions.checkNotNull(value);
        HashMap<String, String> hashMap = this.requestProperties;
        synchronized (hashMap) {
            this.requestProperties.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearRequestProperty(String name) {
        Assertions.checkNotNull(name);
        HashMap<String, String> hashMap = this.requestProperties;
        synchronized (hashMap) {
            this.requestProperties.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllRequestProperties() {
        HashMap<String, String> hashMap = this.requestProperties;
        synchronized (hashMap) {
            this.requestProperties.clear();
        }
    }

    @Override
    public long open(DataSpec dataSpec) throws HttpDataSource.HttpDataSourceException {
        int responseCode;
        this.dataSpec = dataSpec;
        this.bytesRead = 0L;
        this.bytesSkipped = 0L;
        try {
            this.connection = this.makeConnection(dataSpec);
        }
        catch (IOException e) {
            throw new HttpDataSource.HttpDataSourceException("Unable to connect to " + dataSpec.uri.toString(), e, dataSpec, 1);
        }
        try {
            responseCode = this.connection.getResponseCode();
        }
        catch (IOException e) {
            this.closeConnectionQuietly();
            throw new HttpDataSource.HttpDataSourceException("Unable to connect to " + dataSpec.uri.toString(), e, dataSpec, 1);
        }
        if (responseCode < 200 || responseCode > 299) {
            Map<String, List<String>> headers = this.connection.getHeaderFields();
            this.closeConnectionQuietly();
            throw new HttpDataSource.InvalidResponseCodeException(responseCode, headers, dataSpec);
        }
        String contentType = this.connection.getContentType();
        if (this.contentTypePredicate != null && !this.contentTypePredicate.evaluate(contentType)) {
            this.closeConnectionQuietly();
            throw new HttpDataSource.InvalidContentTypeException(contentType, dataSpec);
        }
        long l = this.bytesToSkip = responseCode == 200 && dataSpec.position != 0L ? dataSpec.position : 0L;
        if ((dataSpec.flags & 1) == 0) {
            long contentLength = DefaultHttpDataSource.getContentLength(this.connection);
            this.bytesToRead = dataSpec.length != -1L ? dataSpec.length : (contentLength != -1L ? contentLength - this.bytesToSkip : -1L);
        } else {
            this.bytesToRead = dataSpec.length;
        }
        try {
            this.inputStream = this.connection.getInputStream();
        }
        catch (IOException e) {
            this.closeConnectionQuietly();
            throw new HttpDataSource.HttpDataSourceException(e, dataSpec, 1);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart();
        }
        return this.bytesToRead;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws HttpDataSource.HttpDataSourceException {
        try {
            this.skipInternal();
            return this.readInternal(buffer, offset, readLength);
        }
        catch (IOException e) {
            throw new HttpDataSource.HttpDataSourceException(e, this.dataSpec, 2);
        }
    }

    @Override
    public void close() throws HttpDataSource.HttpDataSourceException {
        block7: {
            try {
                if (this.inputStream == null) break block7;
                Util.maybeTerminateInputStream(this.connection, this.bytesRemaining());
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    throw new HttpDataSource.HttpDataSourceException(e, this.dataSpec, 3);
                }
            }
            finally {
                this.inputStream = null;
                this.closeConnectionQuietly();
                if (this.opened) {
                    this.opened = false;
                    if (this.listener != null) {
                        this.listener.onTransferEnd();
                    }
                }
            }
        }
    }

    protected final HttpURLConnection getConnection() {
        return this.connection;
    }

    protected final long bytesSkipped() {
        return this.bytesSkipped;
    }

    protected final long bytesRead() {
        return this.bytesRead;
    }

    protected final long bytesRemaining() {
        return this.bytesToRead == -1L ? this.bytesToRead : this.bytesToRead - this.bytesRead;
    }

    private HttpURLConnection makeConnection(DataSpec dataSpec) throws IOException {
        boolean allowGzip;
        URL url = new URL(dataSpec.uri.toString());
        byte[] postBody = dataSpec.postBody;
        long position = dataSpec.position;
        long length = dataSpec.length;
        boolean bl = allowGzip = (dataSpec.flags & 1) != 0;
        if (!this.allowCrossProtocolRedirects) {
            HttpURLConnection connection = this.makeConnection(url, postBody, position, length, allowGzip, true);
            return connection;
        }
        int redirectCount = 0;
        while (redirectCount++ <= 20) {
            HttpURLConnection connection = this.makeConnection(url, postBody, position, length, allowGzip, false);
            int responseCode = connection.getResponseCode();
            if (responseCode == 300 || responseCode == 301 || responseCode == 302 || responseCode == 303 || postBody == null && (responseCode == 307 || responseCode == 308)) {
                postBody = null;
                String location = connection.getHeaderField("Location");
                connection.disconnect();
                url = DefaultHttpDataSource.handleRedirect(url, location);
                continue;
            }
            return connection;
        }
        throw new NoRouteToHostException("Too many redirects: " + redirectCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection makeConnection(URL url, byte[] postBody, long position, long length, boolean allowGzip, boolean followRedirects) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(this.connectTimeoutMillis);
        connection.setReadTimeout(this.readTimeoutMillis);
        HashMap<String, String> hashMap = this.requestProperties;
        synchronized (hashMap) {
            for (Map.Entry<String, String> property : this.requestProperties.entrySet()) {
                connection.setRequestProperty(property.getKey(), property.getValue());
            }
        }
        if (position != 0L || length != -1L) {
            String rangeRequest = "bytes=" + position + "-";
            if (length != -1L) {
                rangeRequest = rangeRequest + (position + length - 1L);
            }
            connection.setRequestProperty("Range", rangeRequest);
        }
        connection.setRequestProperty("User-Agent", this.userAgent);
        if (!allowGzip) {
            connection.setRequestProperty("Accept-Encoding", "identity");
        }
        connection.setInstanceFollowRedirects(followRedirects);
        connection.setDoOutput(postBody != null);
        if (postBody != null) {
            connection.setFixedLengthStreamingMode(postBody.length);
            connection.connect();
            OutputStream os = connection.getOutputStream();
            os.write(postBody);
            os.close();
        } else {
            connection.connect();
        }
        return connection;
    }

    private static URL handleRedirect(URL originalUrl, String location) throws IOException {
        if (location == null) {
            throw new ProtocolException("Null location redirect");
        }
        URL url = new URL(originalUrl, location);
        String protocol = url.getProtocol();
        if (!"https".equals(protocol) && !"http".equals(protocol)) {
            throw new ProtocolException("Unsupported protocol redirect: " + protocol);
        }
        return url;
    }

    private static long getContentLength(HttpURLConnection connection) {
        Matcher matcher;
        String contentRangeHeader;
        long contentLength = -1L;
        String contentLengthHeader = connection.getHeaderField("Content-Length");
        if (!TextUtils.isEmpty((CharSequence)contentLengthHeader)) {
            try {
                contentLength = Long.parseLong(contentLengthHeader);
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)("Unexpected Content-Length [" + contentLengthHeader + "]"));
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(contentRangeHeader = connection.getHeaderField("Content-Range"))) && (matcher = CONTENT_RANGE_HEADER.matcher(contentRangeHeader)).find()) {
            try {
                long contentLengthFromRange = Long.parseLong(matcher.group(2)) - Long.parseLong(matcher.group(1)) + 1L;
                if (contentLength < 0L) {
                    contentLength = contentLengthFromRange;
                } else if (contentLength != contentLengthFromRange) {
                    Log.w((String)TAG, (String)("Inconsistent headers [" + contentLengthHeader + "] [" + contentRangeHeader + "]"));
                    contentLength = Math.max(contentLength, contentLengthFromRange);
                }
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)("Unexpected Content-Range [" + contentRangeHeader + "]"));
            }
        }
        return contentLength;
    }

    private void skipInternal() throws IOException {
        if (this.bytesSkipped == this.bytesToSkip) {
            return;
        }
        byte[] skipBuffer = skipBufferReference.getAndSet(null);
        if (skipBuffer == null) {
            skipBuffer = new byte[4096];
        }
        while (this.bytesSkipped != this.bytesToSkip) {
            int readLength = (int)Math.min(this.bytesToSkip - this.bytesSkipped, (long)skipBuffer.length);
            int read = this.inputStream.read(skipBuffer, 0, readLength);
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            if (read == -1) {
                throw new EOFException();
            }
            this.bytesSkipped += (long)read;
            if (this.listener == null) continue;
            this.listener.onBytesTransferred(read);
        }
        skipBufferReference.set(skipBuffer);
    }

    private int readInternal(byte[] buffer, int offset, int readLength) throws IOException {
        int n = readLength = this.bytesToRead == -1L ? readLength : (int)Math.min((long)readLength, this.bytesToRead - this.bytesRead);
        if (readLength == 0) {
            return -1;
        }
        int read = this.inputStream.read(buffer, offset, readLength);
        if (read == -1) {
            if (this.bytesToRead != -1L && this.bytesToRead != this.bytesRead) {
                throw new EOFException();
            }
            return -1;
        }
        this.bytesRead += (long)read;
        if (this.listener != null) {
            this.listener.onBytesTransferred(read);
        }
        return read;
    }

    private void closeConnectionQuietly() {
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Unexpected error while disconnecting", (Throwable)e);
            }
            this.connection = null;
        }
    }
}

