/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.content.Context;
import com.google.android.exoplayer.upstream.AssetDataSource;
import com.google.android.exoplayer.upstream.ContentDataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer.upstream.FileDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

public final class DefaultUriDataSource
implements UriDataSource {
    private static final String SCHEME_ASSET = "asset";
    private static final String SCHEME_CONTENT = "content";
    private final UriDataSource httpDataSource;
    private final UriDataSource fileDataSource;
    private final UriDataSource assetDataSource;
    private final UriDataSource contentDataSource;
    private UriDataSource dataSource;

    public DefaultUriDataSource(Context context, String userAgent) {
        this(context, null, userAgent, false);
    }

    public DefaultUriDataSource(Context context, TransferListener listener, String userAgent) {
        this(context, listener, userAgent, false);
    }

    public DefaultUriDataSource(Context context, TransferListener listener, String userAgent, boolean allowCrossProtocolRedirects) {
        this(context, listener, new DefaultHttpDataSource(userAgent, null, listener, 8000, 8000, allowCrossProtocolRedirects));
    }

    public DefaultUriDataSource(Context context, TransferListener listener, UriDataSource httpDataSource) {
        this.httpDataSource = Assertions.checkNotNull(httpDataSource);
        this.fileDataSource = new FileDataSource(listener);
        this.assetDataSource = new AssetDataSource(context, listener);
        this.contentDataSource = new ContentDataSource(context, listener);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        Assertions.checkState(this.dataSource == null);
        String scheme = dataSpec.uri.getScheme();
        this.dataSource = Util.isLocalFileUri(dataSpec.uri) ? (dataSpec.uri.getPath().startsWith("/android_asset/") ? this.assetDataSource : this.fileDataSource) : (SCHEME_ASSET.equals(scheme) ? this.assetDataSource : (SCHEME_CONTENT.equals(scheme) ? this.contentDataSource : this.httpDataSource));
        return this.dataSource.open(dataSpec);
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws IOException {
        return this.dataSource.read(buffer, offset, readLength);
    }

    @Override
    public String getUri() {
        return this.dataSource == null ? null : this.dataSource.getUri();
    }

    @Override
    public void close() throws IOException {
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            finally {
                this.dataSource = null;
            }
        }
    }
}

