/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileDataSource
implements UriDataSource {
    private final TransferListener listener;
    private RandomAccessFile file;
    private String uriString;
    private long bytesRemaining;
    private boolean opened;

    public FileDataSource() {
        this(null);
    }

    public FileDataSource(TransferListener listener) {
        this.listener = listener;
    }

    @Override
    public long open(DataSpec dataSpec) throws FileDataSourceException {
        try {
            this.uriString = dataSpec.uri.toString();
            this.file = new RandomAccessFile(dataSpec.uri.getPath(), "r");
            this.file.seek(dataSpec.position);
            long l = this.bytesRemaining = dataSpec.length == -1L ? this.file.length() - dataSpec.position : dataSpec.length;
            if (this.bytesRemaining < 0L) {
                throw new EOFException();
            }
        }
        catch (IOException e) {
            throw new FileDataSourceException(e);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart();
        }
        return this.bytesRemaining;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws FileDataSourceException {
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int bytesRead = 0;
        try {
            bytesRead = this.file.read(buffer, offset, (int)Math.min(this.bytesRemaining, (long)readLength));
        }
        catch (IOException e) {
            throw new FileDataSourceException(e);
        }
        if (bytesRead > 0) {
            this.bytesRemaining -= (long)bytesRead;
            if (this.listener != null) {
                this.listener.onBytesTransferred(bytesRead);
            }
        }
        return bytesRead;
    }

    @Override
    public String getUri() {
        return this.uriString;
    }

    @Override
    public void close() throws FileDataSourceException {
        this.uriString = null;
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                throw new FileDataSourceException(e);
            }
            finally {
                this.file = null;
                if (this.opened) {
                    this.opened = false;
                    if (this.listener != null) {
                        this.listener.onTransferEnd();
                    }
                }
            }
        }
    }

    public static class FileDataSourceException
    extends IOException {
        public FileDataSourceException(IOException cause) {
            super(cause);
        }
    }
}

