/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.text.TextUtils;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.util.Predicate;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface HttpDataSource
extends UriDataSource {
    public static final Predicate<String> REJECT_PAYWALL_TYPES = new Predicate<String>(){

        @Override
        public boolean evaluate(String contentType) {
            return !TextUtils.isEmpty((CharSequence)(contentType = Util.toLowerInvariant(contentType))) && (!contentType.contains("text") || contentType.contains("text/vtt")) && !contentType.contains("html") && !contentType.contains("xml");
        }
    };

    @Override
    public long open(DataSpec var1) throws HttpDataSourceException;

    @Override
    public void close() throws HttpDataSourceException;

    @Override
    public int read(byte[] var1, int var2, int var3) throws HttpDataSourceException;

    public void setRequestProperty(String var1, String var2);

    public void clearRequestProperty(String var1);

    public void clearAllRequestProperties();

    public Map<String, List<String>> getResponseHeaders();

    public static final class InvalidResponseCodeException
    extends HttpDataSourceException {
        public final int responseCode;
        public final Map<String, List<String>> headerFields;

        public InvalidResponseCodeException(int responseCode, Map<String, List<String>> headerFields, DataSpec dataSpec) {
            super("Response code: " + responseCode, dataSpec, 1);
            this.responseCode = responseCode;
            this.headerFields = headerFields;
        }
    }

    public static final class InvalidContentTypeException
    extends HttpDataSourceException {
        public final String contentType;

        public InvalidContentTypeException(String contentType, DataSpec dataSpec) {
            super("Invalid content type: " + contentType, dataSpec, 1);
            this.contentType = contentType;
        }
    }

    public static class HttpDataSourceException
    extends IOException {
        public static final int TYPE_OPEN = 1;
        public static final int TYPE_READ = 2;
        public static final int TYPE_CLOSE = 3;
        public final int type;
        public final DataSpec dataSpec;

        public HttpDataSourceException(DataSpec dataSpec, int type) {
            this.dataSpec = dataSpec;
            this.type = type;
        }

        public HttpDataSourceException(String message, DataSpec dataSpec, int type) {
            super(message);
            this.dataSpec = dataSpec;
            this.type = type;
        }

        public HttpDataSourceException(IOException cause, DataSpec dataSpec, int type) {
            super(cause);
            this.dataSpec = dataSpec;
            this.type = type;
        }

        public HttpDataSourceException(String message, IOException cause, DataSpec dataSpec, int type) {
            super(message, cause);
            this.dataSpec = dataSpec;
            this.type = type;
        }
    }
}

