/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSink;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;

public final class TeeDataSource
implements DataSource {
    private final DataSource upstream;
    private final DataSink dataSink;

    public TeeDataSource(DataSource upstream, DataSink dataSink) {
        this.upstream = Assertions.checkNotNull(upstream);
        this.dataSink = Assertions.checkNotNull(dataSink);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        long dataLength = this.upstream.open(dataSpec);
        if (dataSpec.length == -1L && dataLength != -1L) {
            dataSpec = new DataSpec(dataSpec.uri, dataSpec.absoluteStreamPosition, dataSpec.position, dataLength, dataSpec.key, dataSpec.flags);
        }
        this.dataSink.open(dataSpec);
        return dataLength;
    }

    @Override
    public int read(byte[] buffer, int offset, int max) throws IOException {
        int num = this.upstream.read(buffer, offset, max);
        if (num > 0) {
            this.dataSink.write(buffer, offset, num);
        }
        return num;
    }

    @Override
    public void close() throws IOException {
        try {
            this.upstream.close();
        }
        finally {
            this.dataSink.close();
        }
    }
}

