/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream.cache;

import android.net.Uri;
import android.util.Log;
import com.google.android.exoplayer.upstream.DataSink;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.FileDataSource;
import com.google.android.exoplayer.upstream.TeeDataSource;
import com.google.android.exoplayer.upstream.cache.Cache;
import com.google.android.exoplayer.upstream.cache.CacheDataSink;
import com.google.android.exoplayer.upstream.cache.CacheSpan;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;

public final class CacheDataSource
implements DataSource {
    private static final String TAG = "CacheDataSource";
    private final Cache cache;
    private final DataSource cacheReadDataSource;
    private final DataSource cacheWriteDataSource;
    private final DataSource upstreamDataSource;
    private final EventListener eventListener;
    private final boolean blockOnCache;
    private final boolean ignoreCacheOnError;
    private DataSource currentDataSource;
    private Uri uri;
    private int flags;
    private String key;
    private long readPosition;
    private long bytesRemaining;
    private CacheSpan lockedSpan;
    private boolean ignoreCache;
    private long totalCachedBytesRead;

    public CacheDataSource(Cache cache, DataSource upstream, boolean blockOnCache, boolean ignoreCacheOnError) {
        this(cache, upstream, blockOnCache, ignoreCacheOnError, Long.MAX_VALUE);
    }

    public CacheDataSource(Cache cache, DataSource upstream, boolean blockOnCache, boolean ignoreCacheOnError, long maxCacheFileSize) {
        this(cache, upstream, new FileDataSource(), new CacheDataSink(cache, maxCacheFileSize), blockOnCache, ignoreCacheOnError, null);
    }

    public CacheDataSource(Cache cache, DataSource upstream, DataSource cacheReadDataSource, DataSink cacheWriteDataSink, boolean blockOnCache, boolean ignoreCacheOnError, EventListener eventListener) {
        this.cache = cache;
        this.cacheReadDataSource = cacheReadDataSource;
        this.blockOnCache = blockOnCache;
        this.ignoreCacheOnError = ignoreCacheOnError;
        this.upstreamDataSource = upstream;
        this.cacheWriteDataSource = cacheWriteDataSink != null ? new TeeDataSource(upstream, cacheWriteDataSink) : null;
        this.eventListener = eventListener;
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        try {
            this.uri = dataSpec.uri;
            this.flags = dataSpec.flags;
            this.key = dataSpec.key;
            this.readPosition = dataSpec.position;
            this.bytesRemaining = dataSpec.length;
            this.openNextSource();
            return dataSpec.length;
        }
        catch (IOException e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    @Override
    public int read(byte[] buffer, int offset, int max) throws IOException {
        try {
            int bytesRead = this.currentDataSource.read(buffer, offset, max);
            if (bytesRead >= 0) {
                if (this.currentDataSource == this.cacheReadDataSource) {
                    this.totalCachedBytesRead += (long)bytesRead;
                }
                this.readPosition += (long)bytesRead;
                if (this.bytesRemaining != -1L) {
                    this.bytesRemaining -= (long)bytesRead;
                }
            } else {
                this.closeCurrentSource();
                if (this.bytesRemaining > 0L && this.bytesRemaining != -1L) {
                    this.openNextSource();
                    return this.read(buffer, offset, max);
                }
            }
            return bytesRead;
        }
        catch (IOException e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.notifyBytesRead();
        try {
            this.closeCurrentSource();
        }
        catch (IOException e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    private void openNextSource() throws IOException {
        DataSpec dataSpec;
        CacheSpan span;
        if (this.ignoreCache) {
            span = null;
        } else if (this.bytesRemaining == -1L) {
            Log.w((String)TAG, (String)"Cache bypassed due to unbounded length.");
            span = null;
        } else if (this.blockOnCache) {
            try {
                span = this.cache.startReadWrite(this.key, this.readPosition);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        } else {
            span = this.cache.startReadWriteNonBlocking(this.key, this.readPosition);
        }
        if (span == null) {
            this.currentDataSource = this.upstreamDataSource;
            dataSpec = new DataSpec(this.uri, this.readPosition, this.bytesRemaining, this.key, this.flags);
        } else if (span.isCached) {
            Uri fileUri = Uri.fromFile((File)span.file);
            long filePosition = this.readPosition - span.position;
            long length = Math.min(span.length - filePosition, this.bytesRemaining);
            dataSpec = new DataSpec(fileUri, this.readPosition, filePosition, length, this.key, this.flags);
            this.currentDataSource = this.cacheReadDataSource;
        } else {
            this.lockedSpan = span;
            long length = span.isOpenEnded() ? this.bytesRemaining : Math.min(span.length, this.bytesRemaining);
            dataSpec = new DataSpec(this.uri, this.readPosition, length, this.key, this.flags);
            this.currentDataSource = this.cacheWriteDataSource != null ? this.cacheWriteDataSource : this.upstreamDataSource;
        }
        this.currentDataSource.open(dataSpec);
    }

    private void closeCurrentSource() throws IOException {
        if (this.currentDataSource == null) {
            return;
        }
        try {
            this.currentDataSource.close();
            this.currentDataSource = null;
        }
        finally {
            if (this.lockedSpan != null) {
                this.cache.releaseHoleSpan(this.lockedSpan);
                this.lockedSpan = null;
            }
        }
    }

    private void handleBeforeThrow(IOException exception) {
        if (this.ignoreCacheOnError && (this.currentDataSource == this.cacheReadDataSource || exception instanceof CacheDataSink.CacheDataSinkException)) {
            this.ignoreCache = true;
        }
    }

    private void notifyBytesRead() {
        if (this.eventListener != null && this.totalCachedBytesRead > 0L) {
            this.eventListener.onCachedBytesRead(this.cache.getCacheSpace(), this.totalCachedBytesRead);
            this.totalCachedBytesRead = 0L;
        }
    }

    public static interface EventListener {
        public void onCachedBytesRead(long var1, long var3);
    }
}

