/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream.cache;

import com.google.android.exoplayer.upstream.cache.Cache;
import com.google.android.exoplayer.upstream.cache.CacheEvictor;
import com.google.android.exoplayer.upstream.cache.CacheSpan;
import java.util.Comparator;
import java.util.TreeSet;

public final class LeastRecentlyUsedCacheEvictor
implements CacheEvictor,
Comparator<CacheSpan> {
    private final long maxBytes;
    private final TreeSet<CacheSpan> leastRecentlyUsed;
    private long currentSize;

    public LeastRecentlyUsedCacheEvictor(long maxBytes) {
        this.maxBytes = maxBytes;
        this.leastRecentlyUsed = new TreeSet<CacheSpan>(this);
    }

    @Override
    public void onCacheInitialized() {
    }

    @Override
    public void onStartFile(Cache cache, String key, long position, long length) {
        this.evictCache(cache, length);
    }

    @Override
    public void onSpanAdded(Cache cache, CacheSpan span) {
        this.leastRecentlyUsed.add(span);
        this.currentSize += span.length;
        this.evictCache(cache, 0L);
    }

    @Override
    public void onSpanRemoved(Cache cache, CacheSpan span) {
        this.leastRecentlyUsed.remove(span);
        this.currentSize -= span.length;
    }

    @Override
    public void onSpanTouched(Cache cache, CacheSpan oldSpan, CacheSpan newSpan) {
        this.onSpanRemoved(cache, oldSpan);
        this.onSpanAdded(cache, newSpan);
    }

    @Override
    public int compare(CacheSpan lhs, CacheSpan rhs) {
        long lastAccessTimestampDelta = lhs.lastAccessTimestamp - rhs.lastAccessTimestamp;
        if (lastAccessTimestampDelta == 0L) {
            return lhs.compareTo(rhs);
        }
        return lhs.lastAccessTimestamp < rhs.lastAccessTimestamp ? -1 : 1;
    }

    private void evictCache(Cache cache, long requiredSpace) {
        while (this.currentSize + requiredSpace > this.maxBytes) {
            cache.removeSpan(this.leastRecentlyUsed.first());
        }
    }
}

