/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import android.util.Pair;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.ParsableBitArray;
import java.util.ArrayList;

public final class CodecSpecificDataUtil {
    private static final byte[] NAL_START_CODE = new byte[]{0, 0, 0, 1};
    private static final int AUDIO_SPECIFIC_CONFIG_FREQUENCY_INDEX_ARBITRARY = 15;
    private static final int[] AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350};
    private static final int AUDIO_SPECIFIC_CONFIG_CHANNEL_CONFIGURATION_INVALID = -1;
    private static final int[] AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE = new int[]{0, 1, 2, 3, 4, 5, 6, 8, -1, -1, -1, 7, 8, -1, 8, -1};
    private static final int AUDIO_OBJECT_TYPE_AAC_LC = 2;
    private static final int AUDIO_OBJECT_TYPE_SBR = 5;
    private static final int AUDIO_OBJECT_TYPE_ER_BSAC = 22;
    private static final int AUDIO_OBJECT_TYPE_PS = 29;

    private CodecSpecificDataUtil() {
    }

    public static Pair<Integer, Integer> parseAacAudioSpecificConfig(byte[] audioSpecificConfig) {
        int channelCount;
        int sampleRate;
        ParsableBitArray bitArray = new ParsableBitArray(audioSpecificConfig);
        int audioObjectType = bitArray.readBits(5);
        int frequencyIndex = bitArray.readBits(4);
        if (frequencyIndex == 15) {
            sampleRate = bitArray.readBits(24);
        } else {
            Assertions.checkArgument(frequencyIndex < 13);
            sampleRate = AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE[frequencyIndex];
        }
        int channelConfiguration = bitArray.readBits(4);
        if (audioObjectType == 5 || audioObjectType == 29) {
            frequencyIndex = bitArray.readBits(4);
            if (frequencyIndex == 15) {
                sampleRate = bitArray.readBits(24);
            } else {
                Assertions.checkArgument(frequencyIndex < 13);
                sampleRate = AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE[frequencyIndex];
            }
            audioObjectType = bitArray.readBits(5);
            if (audioObjectType == 22) {
                channelConfiguration = bitArray.readBits(4);
            }
        }
        Assertions.checkArgument((channelCount = AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE[channelConfiguration]) != -1);
        return Pair.create((Object)sampleRate, (Object)channelCount);
    }

    public static byte[] buildAacAudioSpecificConfig(int audioObjectType, int sampleRateIndex, int channelConfig) {
        byte[] audioSpecificConfig = new byte[]{(byte)(audioObjectType << 3 & 0xF8 | sampleRateIndex >> 1 & 7), (byte)(sampleRateIndex << 7 & 0x80 | channelConfig << 3 & 0x78)};
        return audioSpecificConfig;
    }

    public static byte[] buildAacAudioSpecificConfig(int sampleRate, int numChannels) {
        int sampleRateIndex = -1;
        for (int i = 0; i < AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE.length; ++i) {
            if (sampleRate != AUDIO_SPECIFIC_CONFIG_SAMPLING_RATE_TABLE[i]) continue;
            sampleRateIndex = i;
        }
        int channelConfig = -1;
        for (int i = 0; i < AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE.length; ++i) {
            if (numChannels != AUDIO_SPECIFIC_CONFIG_CHANNEL_COUNT_TABLE[i]) continue;
            channelConfig = i;
        }
        byte[] csd = new byte[]{(byte)(0x10 | sampleRateIndex >> 1), (byte)((sampleRateIndex & 1) << 7 | channelConfig << 3)};
        return csd;
    }

    public static byte[] buildNalUnit(byte[] data, int offset, int length) {
        byte[] nalUnit = new byte[length + NAL_START_CODE.length];
        System.arraycopy(NAL_START_CODE, 0, nalUnit, 0, NAL_START_CODE.length);
        System.arraycopy(data, offset, nalUnit, NAL_START_CODE.length, length);
        return nalUnit;
    }

    public static byte[][] splitNalUnits(byte[] data) {
        if (!CodecSpecificDataUtil.isNalStartCode(data, 0)) {
            return null;
        }
        ArrayList<Integer> starts = new ArrayList<Integer>();
        int nalUnitIndex = 0;
        do {
            starts.add(nalUnitIndex);
        } while ((nalUnitIndex = CodecSpecificDataUtil.findNalStartCode(data, nalUnitIndex + NAL_START_CODE.length)) != -1);
        byte[][] split = new byte[starts.size()][];
        for (int i = 0; i < starts.size(); ++i) {
            int startIndex = (Integer)starts.get(i);
            int endIndex = i < starts.size() - 1 ? (Integer)starts.get(i + 1) : data.length;
            byte[] nal = new byte[endIndex - startIndex];
            System.arraycopy(data, startIndex, nal, 0, nal.length);
            split[i] = nal;
        }
        return split;
    }

    private static int findNalStartCode(byte[] data, int index) {
        int endIndex = data.length - NAL_START_CODE.length;
        for (int i = index; i <= endIndex; ++i) {
            if (!CodecSpecificDataUtil.isNalStartCode(data, i)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isNalStartCode(byte[] data, int index) {
        if (data.length - index <= NAL_START_CODE.length) {
            return false;
        }
        for (int j = 0; j < NAL_START_CODE.length; ++j) {
            if (data[index + j] == NAL_START_CODE[j]) continue;
            return false;
        }
        return true;
    }
}

