/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import android.widget.TextView;
import com.google.android.exoplayer.CodecCounters;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.upstream.BandwidthMeter;

public final class DebugTextViewHelper
implements Runnable {
    private static final int REFRESH_INTERVAL_MS = 1000;
    private final TextView textView;
    private final Provider debuggable;

    public DebugTextViewHelper(Provider debuggable, TextView textView) {
        this.debuggable = debuggable;
        this.textView = textView;
    }

    public void start() {
        this.stop();
        this.run();
    }

    public void stop() {
        this.textView.removeCallbacks((Runnable)this);
    }

    @Override
    public void run() {
        this.textView.setText((CharSequence)this.getRenderString());
        this.textView.postDelayed((Runnable)this, 1000L);
    }

    private String getRenderString() {
        return this.getTimeString() + " " + this.getQualityString() + " " + this.getBandwidthString() + " " + this.getVideoCodecCountersString();
    }

    private String getTimeString() {
        return "ms(" + this.debuggable.getCurrentPosition() + ")";
    }

    private String getQualityString() {
        Format format = this.debuggable.getFormat();
        return format == null ? "id:? br:? h:?" : "id:" + format.id + " br:" + format.bitrate + " h:" + format.height;
    }

    private String getBandwidthString() {
        BandwidthMeter bandwidthMeter = this.debuggable.getBandwidthMeter();
        if (bandwidthMeter == null || bandwidthMeter.getBitrateEstimate() == -1L) {
            return "bw:?";
        }
        return "bw:" + bandwidthMeter.getBitrateEstimate() / 1000L;
    }

    private String getVideoCodecCountersString() {
        CodecCounters codecCounters = this.debuggable.getCodecCounters();
        return codecCounters == null ? "" : codecCounters.getDebugString();
    }

    public static interface Provider {
        public long getCurrentPosition();

        public Format getFormat();

        public BandwidthMeter getBandwidthMeter();

        public CodecCounters getCodecCounters();
    }
}

