/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;

public final class FlacSeekTable {
    private static final int METADATA_LENGTH_OFFSET = 1;
    private static final int SEEK_POINT_SIZE = 18;
    private final long[] sampleNumbers;
    private final long[] offsets;

    public static FlacSeekTable parseSeekTable(ParsableByteArray data) {
        data.skipBytes(1);
        int length = data.readUnsignedInt24();
        int numberOfSeekPoints = length / 18;
        long[] sampleNumbers = new long[numberOfSeekPoints];
        long[] offsets = new long[numberOfSeekPoints];
        for (int i = 0; i < numberOfSeekPoints; ++i) {
            sampleNumbers[i] = data.readLong();
            offsets[i] = data.readLong();
            data.skipBytes(2);
        }
        return new FlacSeekTable(sampleNumbers, offsets);
    }

    private FlacSeekTable(long[] sampleNumbers, long[] offsets) {
        this.sampleNumbers = sampleNumbers;
        this.offsets = offsets;
    }

    public SeekMap createSeekMap(final long firstFrameOffset, final long sampleRate) {
        return new SeekMap(){

            @Override
            public boolean isSeekable() {
                return true;
            }

            @Override
            public long getPosition(long timeUs) {
                long sample = timeUs * sampleRate / 1000000L;
                int index = Util.binarySearchFloor(FlacSeekTable.this.sampleNumbers, sample, true, true);
                return firstFrameOffset + FlacSeekTable.this.offsets[index];
            }
        };
    }
}

