/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util.extensions;

import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.extensions.Buffer;
import com.google.android.exoplayer.util.extensions.Decoder;
import com.google.android.exoplayer.util.extensions.InputBuffer;
import com.google.android.exoplayer.util.extensions.OutputBuffer;
import java.util.LinkedList;

public abstract class SimpleDecoder<I extends InputBuffer, O extends OutputBuffer, E extends Exception>
extends Thread
implements Decoder<I, O, E> {
    private final Object lock = new Object();
    private final LinkedList<I> queuedInputBuffers = new LinkedList();
    private final LinkedList<O> queuedOutputBuffers = new LinkedList();
    private final I[] availableInputBuffers;
    private final O[] availableOutputBuffers;
    private int availableInputBufferCount;
    private int availableOutputBufferCount;
    private I dequeuedInputBuffer;
    private E exception;
    private boolean flushed;
    private boolean released;

    protected SimpleDecoder(I[] inputBuffers, O[] outputBuffers) {
        int i;
        this.availableInputBuffers = inputBuffers;
        this.availableInputBufferCount = inputBuffers.length;
        for (i = 0; i < this.availableInputBufferCount; ++i) {
            this.availableInputBuffers[i] = this.createInputBuffer();
        }
        this.availableOutputBuffers = outputBuffers;
        this.availableOutputBufferCount = outputBuffers.length;
        for (i = 0; i < this.availableOutputBufferCount; ++i) {
            this.availableOutputBuffers[i] = this.createOutputBuffer();
        }
    }

    protected final void setInitialInputBufferSize(int size) {
        Assertions.checkState(this.availableInputBufferCount == this.availableInputBuffers.length);
        for (int i = 0; i < this.availableInputBuffers.length; ++i) {
            ((InputBuffer)this.availableInputBuffers[i]).sampleHolder.ensureSpaceForWrite(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final I dequeueInputBuffer() throws E {
        Object object = this.lock;
        synchronized (object) {
            this.maybeThrowException();
            Assertions.checkState(this.dequeuedInputBuffer == null);
            if (this.availableInputBufferCount == 0) {
                return null;
            }
            I inputBuffer = this.availableInputBuffers[--this.availableInputBufferCount];
            ((InputBuffer)inputBuffer).reset();
            this.dequeuedInputBuffer = inputBuffer;
            return inputBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void queueInputBuffer(I inputBuffer) throws E {
        Object object = this.lock;
        synchronized (object) {
            this.maybeThrowException();
            Assertions.checkArgument(inputBuffer == this.dequeuedInputBuffer);
            this.queuedInputBuffers.addLast(inputBuffer);
            this.maybeNotifyDecodeLoop();
            this.dequeuedInputBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final O dequeueOutputBuffer() throws E {
        Object object = this.lock;
        synchronized (object) {
            this.maybeThrowException();
            if (this.queuedOutputBuffers.isEmpty()) {
                return null;
            }
            return (O)((OutputBuffer)this.queuedOutputBuffers.removeFirst());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseOutputBuffer(O outputBuffer) {
        Object object = this.lock;
        synchronized (object) {
            this.availableOutputBuffers[this.availableOutputBufferCount++] = outputBuffer;
            this.maybeNotifyDecodeLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush() {
        Object object = this.lock;
        synchronized (object) {
            this.flushed = true;
            if (this.dequeuedInputBuffer != null) {
                this.availableInputBuffers[this.availableInputBufferCount++] = this.dequeuedInputBuffer;
                this.dequeuedInputBuffer = null;
            }
            while (!this.queuedInputBuffers.isEmpty()) {
                this.availableInputBuffers[this.availableInputBufferCount++] = (InputBuffer)this.queuedInputBuffers.removeFirst();
            }
            while (!this.queuedOutputBuffers.isEmpty()) {
                this.availableOutputBuffers[this.availableOutputBufferCount++] = (OutputBuffer)this.queuedOutputBuffers.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            this.released = true;
            this.lock.notify();
        }
        try {
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void maybeThrowException() throws E {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private void maybeNotifyDecodeLoop() {
        if (this.canDecodeBuffer()) {
            this.lock.notify();
        }
    }

    @Override
    public final void run() {
        try {
            while (this.decode()) {
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decode() throws InterruptedException {
        boolean resetDecoder;
        O outputBuffer;
        InputBuffer inputBuffer;
        Object object = this.lock;
        synchronized (object) {
            while (!this.released && !this.canDecodeBuffer()) {
                this.lock.wait();
            }
            if (this.released) {
                return false;
            }
            inputBuffer = (InputBuffer)this.queuedInputBuffers.removeFirst();
            outputBuffer = this.availableOutputBuffers[--this.availableOutputBufferCount];
            resetDecoder = this.flushed;
            this.flushed = false;
        }
        ((Buffer)outputBuffer).reset();
        if (inputBuffer.getFlag(1)) {
            ((Buffer)outputBuffer).setFlag(1);
        } else {
            if (inputBuffer.getFlag(2)) {
                ((Buffer)outputBuffer).setFlag(2);
            }
            this.exception = this.decode(inputBuffer, outputBuffer, resetDecoder);
            if (this.exception != null) {
                object = this.lock;
                synchronized (object) {
                }
                return false;
            }
        }
        object = this.lock;
        synchronized (object) {
            if (this.flushed || ((Buffer)outputBuffer).getFlag(2)) {
                this.availableOutputBuffers[this.availableOutputBufferCount++] = outputBuffer;
            } else {
                this.queuedOutputBuffers.addLast(outputBuffer);
            }
            this.availableInputBuffers[this.availableInputBufferCount++] = inputBuffer;
        }
        return true;
    }

    private boolean canDecodeBuffer() {
        return !this.queuedInputBuffers.isEmpty() && this.availableOutputBufferCount > 0;
    }

    protected abstract I createInputBuffer();

    protected abstract O createOutputBuffer();

    protected abstract E decode(I var1, O var2, boolean var3);

    public static interface EventListener<E> {
        public void onDecoderError(E var1);
    }
}

