# Makefiles including common.mak must ensure the following variables have the appropriate value
# - MODULE_ROOT: absolute path of the DSMCC module
# Makefiles including common.mak can set the following variables
# - MODULE_PREREQUISITES: prerequisites needed by the calling Makefile (which has to define the relative rules)
# - COMP: component name used to create bin/$(COMP)/ for object files and bin/. Missing when included from the top level Makefile

ifeq ($(DTVKIT_CC),)
$(warning DTVKIT_CC not set, using $(CC))
DTVKIT_CC=$(CC)
endif

ifeq ($(DTVKIT_AR),)
$(warning DTVKIT_AR not set, using $(AR))
DTVKIT_AR=$(AR)
endif

# CFLAGS is reset here
ifeq ($(DTVKIT_BUILD_MODE),release)
CFLAGS = $(DTVKIT_OPTIMISATION_OPTION)
DEFINES += NDEBUG
else
CFLAGS = -g
DEFINES += DSM_DP_LEVEL=$(DTVKIT_DSMCC_DEBUG_LEVEL) DSM_DBG_MASK=$(DTVKIT_DSMCC_DEBUG_MASK)
ifeq ($(DTVKIT_DSMCC_DEBUG_ASSERT),1)
DEFINES += DEBUG_ASSERT
endif
endif

ifneq ($(DTVKIT_USE_STDINT),1)
DEFINES += NO_STDINT_H
endif

CFLAGS += $(DTVKIT_ADDITIONAL_COMPILER_OPTIONS)

QUIET ?= @

DFLAG = -MMD

CFLAGS += $(patsubst %,-W%,$(sort $(WARNINGS)))
CFLAGS += $(patsubst %,-D%,$(sort $(DEFINES)))
CFLAGS += $(patsubst %,-I%,$(sort $(INCDIRS)))

COMPDIR := $(shell pwd)
DIRLIST := $(subst /, ,$(COMPDIR))
COMP = $(word $(words $(DIRLIST)),$(DIRLIST))

# directory to put the *.o *.d *.P files for this component
OBJDIR = $(OBJ_BUILD_PATH)/$(COMP)

# Library name for component.
TRGT_LIB = $(OBJ_BUILD_PATH)/lib$(COMP).a
TRGT ?= $(TRGT_LIB)

SRCDIR?=src
DEPF = $(OBJDIR)/$(*F)
OBJS  = ${SOURCES:%=$(OBJDIR)/%.o}

DTVKIT_OSTYPE ?= linux-gnu
DTVKIT_TOOLS_PATH ?= $(MODULE_ROOT)/tools/bin/$(DTVKIT_OSTYPE)

ifeq ($(findstring linux-gnu,$(DTVKIT_OSTYPE)),linux-gnu)
 # Determine whether this is a 32 or 64 bit sysyem
 SYS_TYPE = $(shell uname -m)
 ifeq ($(findstring x86_64,$(SYS_TYPE)), x86_64)
  CMD_amsdeps = $(DTVKIT_TOOLS_PATH)/amsdeps64
  CMD_outdeps = $(DTVKIT_TOOLS_PATH)/outdeps64
 else
  CMD_amsdeps = $(DTVKIT_TOOLS_PATH)/amsdeps32
  CMD_outdeps = $(DTVKIT_TOOLS_PATH)/outdeps32
 endif
else
 CMD_amsdeps = $(DTVKIT_TOOLS_PATH)/amsdeps
 CMD_outdeps = $(DTVKIT_TOOLS_PATH)/outdeps
endif

CMD_coan = $(DTVKIT_TOOLS_PATH)/coan

define d_to_g
   @mv $(DEPF).d $(DEPF).g
endef
define d_to_m
   @mv $(DEPF).d $(DEPF).m
endef


# define the commands for compiling ...
define compile
	@echo Compiling $(<F)
	$(QUIET)$(DTVKIT_CC) $(DFLAG) $(CFLAGS) -o $@ -c $<
	$(d_to_g)
	@cat $(DEPF).g | sed -e 's/#.*//' -e 's/^[^:]*: *//' -e 's/ *\\$$//' -e '/^$$/ d' > $(DEPF).d
	@cat $(DEPF).d | sed -e 's/$$/ :/' > $(DEPF).t;
	$(d_to_m)
	@echo "FDEPS_$(*F)=" > $(DEPF).d
	-@$(CMD_coan) symbols -i -o -f $(DEPF).m 2>/dev/null | sed -e 's/.*_H$$//' -e '/^$$/ d' >> $(DEPF).d
	@cat $(DEPF).d | sed -e :a -e N -e 's/\n/ /' -e ta > $(DEPF).m
	@$(CMD_outdeps) $(*F) $(DEPF).x $(DEFINES)
	@cat $(DEPF).g | sed -e 's/\.h$$/.h \\/' -e 's/\.c$$/.c \\/' > $(DEPF).d;
	@cat $(DEPF).m $(DEPF).x $(DEPF).N $(DEPF).d $(DEPF).Q $(DEPF).t > $(DEPF).P;
	@rm $(DEPF).d $(DEPF).t $(DEPF).m $(DEPF).g $(DEPF).x
endef

#
# Psuedo targets
#
.PHONY : force clean

#
# Default target
#
default : $(MODULE_PREREQUISITES) $(OBJDIR) $(OBJS:%.o=%.N) $(TRGT)
	-@rm -f cmd_coan.mk

#
# Rule to create target library
#
$(TRGT_LIB): $(OBJS)
	@echo Building $@
	$(QUIET)$(DTVKIT_AR) rsc $@ $^

#
# Rule to create object list
#
$(OBJDIR)/objs.mk : $(OBJS)
	@echo "OBJS+=$^" > $@

#
# The compile rule
#
$(OBJDIR)/%.o: $(SRCDIR)/%.c
	$(compile)

$(OBJDIR)/%.N : $(OBJDIR)/%.E
	@mv $< $@

$(OBJDIR)/%.N :
	@echo Generating $(@F)
	@$(CMD_amsdeps) $* $@

#
# Rule to make required directories
#
$(OBJDIR) $(INC_BUILD_PATH) $(SRC_BUILD_PATH):
	@echo Creating $@
	@mkdir -p $@

clean: module_clean
	@rm -f $(OBJS:%.o=%.?)
	@rm -f $(OBJDIR)/objs.mk
	@rm -f $(TRGT_LIB)
	@rm -rf $(OBJDIR)
	-rmdir $(OBJDIR)
	-rmdir $(OBJ_BUILD_PATH)
	-rmdir $(INC_BUILD_PATH)
	-rmdir $(SRC_BUILD_PATH)


show:
	@echo COMP=$(COMP)
	@echo DEFINES=$(DEFINES)
	@echo OBJDIR=$(OBJDIR)
	@echo TRGT_LIB=$(TRGT_LIB)

ifneq ($(MAKECMDGOALS),clean)
# include dependencies for this component
-include $(OBJS:%.o=%.P)
endif

