# Variables added for the build system

# Folder where the compilation products will be placed. This overrides the default 'build'
#export DTVKIT_OUTPUT_DIR=

# Configure size of demux reference variable. Default 1 byte
#export DTVKIT_SIZEOF_DMX_REF=1
# Configure number of handles to reference section filter. Default 2 (one for PID filter, one for section filter) 
#export DTVKIT_FILTER_HANDLES=2

# Select which pre-built tools to be used in make system
# Set to 'rpi' to build on the Raspberry Pi
export DTVKIT_OSTYPE=linux-gnu

export DTVKIT_CC=cc
export DTVKIT_AR=ar

# Set to '1' to include 'stdint.h'. For 64 bit compilation, this must be set to '1' 
export DTVKIT_USE_STDINT=0

# Additional compiler options
#export DTVKIT_ADDITIONAL_COMPILER_OPTIONS=

# When compiling in release mode, this overrides the default -O2
#export DTVKIT_OPTIMISATION_OPTION=

# If set to 'release', it overrides the default mode 'debug'
#export DTVKIT_BUILD_MODE=

# Set the level of debug - 0 - none, 1 - error only, 2 - error and warnings, 3 and 4 are more verbose levels
export DTVKIT_DSMCC_DEBUG_LEVEL=0

# Debug mask, working in conjuction with level 2 and above, selects specific areas of debug
export DTVKIT_DSMCC_DEBUG_MASK=0x0000

# If set, enables use of getenv() to retrieve debug mask items from environment with DSMCC_DebugInstanceEnable() 
#export DTVKIT_DSMCC_DEBUG_USE_GETENV=1

# In debug build, if this is set to 1, any assert will use the platform debug function 'STB_SPDebugAssertFail'
# export DTVKIT_DSMCC_DEBUG_ASSERT=0

# Location of third party libraries source code
# Needed by libdsmcc.a
export DTVKIT_ZLIB_INCLUDE_PATH=/usr/include

# Turn off timeout support for DSI sections (default is ON)
# export DTVKIT_DSMCC_DSI_TIMEOUT=0
