/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   DSM-CC API functions to control DSM-CC instance
 * @file    dsm_debug.h
 * @date    21/08/2014
 * @author  Adam Sturtridge
 */

#ifndef _DSM_DEBUG_H
#define _DSM_DEBUG_H

#include "dsm_types.h"

/*---Constant and macro definitions for public use-----------------------------*/

/* debug states for DSMCC core */
/* General */
#define DD_GEN     (1 << 0)
/* Object Carousel */
#define DD_OC      (1 << 1)
/* Section Filtering */
#define DD_SF      (1 << 2)
/* Timers */
#define DD_TIMER   (1 << 3)
/* Stream Events */
#define DD_SE      (1 << 4)
/* Load manager */
#define DD_LM      (1 << 5)
/* Object Loading */
#define DD_OBJ     (1 << 6)
/* Data Carousel */
#define DD_DC      (1 << 7)
/* SI Query */
#define DD_QUERY   (1 << 8)
/* Modules */
#define DD_MOD     (1 << 9)
#define DD_ALL     ((1 << 10) - 1)

/* debug states for service info */
#define DS_MAIN    (1 << 16)
#define DS_QUERY   (1 << 17)
#define DS_CACHE   (1 << 18)
#define DS_PMT     (1 << 19)
#define DS_PAT     (1 << 20)
#define DS_FUNC    (1 << 21)
#define DS_ALL     (31 << 16)

/* debug states for section filtering */
#define DF_MAIN    (1 << 24)
#define DF_FILTER  (1 << 25)
#define DF_CACHE   (1 << 26)
#define DF_HWSF    (1 << 27)
#define DF_ALL     (15 << 24)

/* debug states for DSMCC main API */
#define DM_SI      (1 << 29)
#define DM_CONTROL (1 << 30)
#define DM_CLIENT  (1 << 31)

/*---Enumerations for public use-----------------------------------------------*/

/*---Global type defs for public use-------------------------------------------*/

/*---Global Function prototypes for public use---------------------------------*/

/**
 * @brief    Get the DSMCC debug mask.
 * @return   Debug mask
 */
U32BIT DSMCC_DebugGetMask(void);

/**
 * @brief   Set the DSMCC debug mask.
 * @param   mask mask value
 * @return  void
 */
void DSMCC_DebugSetMask(U32BIT mask);

/**
 * @brief   Get the DSMCC debug mask for instance.
 * @param   dsmctrl DSM control instance handle
 * @return  Debug mask
 */
U32BIT DSMCC_DebugInstanceGetMask(H_DsmControl instance);

/**
 * @brief   Set the DSMCC debug mask.
 * @param   instance DSM control instance handle
 * @param   mask mask value
 * @return  void
 */
void DSMCC_DebugInstanceSetMask(H_DsmControl instance, U32BIT mask);

/**
 * @brief   Enable DSMCC debug for an instance, by reading environment variables
 *          with name format: <rootname>_<maskname>. E.g. DSMOTA_DS_PMT
 * @param   instance DSM control instance handle
 * @param   rootname Root name for environment variables for this instance
 * @return  void
 */
void DSMCC_DebugInstanceEnable(H_DsmControl dsmctrl, const char *rootname);

#endif /*_DSM_DEBUG_H */
