/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2013 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   File System types
 * @file    fs_types.h
 * @date    23/12/2013
 * @author  Adam Sturtridge
 */

#ifndef _FS_TYPES_H
#define _FS_TYPES_H

#include <techtype.h>

typedef enum
{
   FS_STATUS_OK,
   FS_STATUS_PENDING,
   FS_STATUS_NONE,
   FS_STATUS_ABORT,
   FS_STATUS_INVALID,
   FS_STATUS_ERROR
} E_FsStatus;

typedef void *FS_HANDLE;
typedef void (*F_DESTROY)( FS_HANDLE fs_handle );

/* STRUCTURE: S_CONTENT
 * Used to return file data after requests to File systems
 */
typedef struct s_content
{
   U32BIT size;            /* Size of data in bytes */
   U8BIT *data;            /* Pointer to data.*/
   F_DESTROY destroy;      /* Relevant destroy/destruct/clear function */
   FS_HANDLE fs_handle;    /* File System Handle */
   void *user_data;        /* User Data */
} S_CONTENT;

/**
* @brief Callback function to notify client of result for a file system load
*        request. This is intented for asynchronous call back.
* @param E_FsStatus result  Result of the load request
* @param S_CONTENT *pContent  Structure holding content details (e.g. file data)
**/
typedef void (*F_FS_CALLBACK)( E_FsStatus result, S_CONTENT *pContent );

#endif /*_FS_TYPES_H*/
