/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2013 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   API to register PMT Observer with DVB SI task
 * @file    stbsipmt.h
 * @date    23/01/2013
 * @author  Adam Sturtridge
 */

#ifndef _STBSIPMT_H
#define _STBSIPMT_H

typedef void (*F_PmtObserver)( U16BIT service_id, U8BIT *pmt );


void STB_SIRegisterPmtObserver( F_PmtObserver func );

void STB_SIUnregisterPmtObserver( F_PmtObserver func );

#endif /* _STBSIPMT_H */
