/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2013 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   DSM Debug API header
 * @file    cldsmdbg.h
 * @date    28 September 2013
 * @author  Adam Sturtridge
 */
#ifndef _DSMDEBUG_H_
#define _DSMDEBUG_H_
/*-------------------------------- Includes ----------------------------------*/

#include "stdfuncs.h"
#include "dsm_debug.h"
#include "cldsmtypes.h"

#ifdef __cplusplus
extern "C" {
#endif

/*-------------------------------- Defines -----------------------------------*/

/*-------------------------------- Types -------------------------------------*/

/*------------------------------  Exported Data  -----------------------------*/


/*------------------------------ Prototypes ----------------------------------*/

/**
 * @brief   Sets debug print functions for four different levels of detail.
 *          Any of these parameters can be set to NULL to turn off output
 *          All can be same function and default is NULL for all.
 * @param   F_Printf  errorFunc   Pointer to error print function
 * @param   F_Printf  warmFunc    Pointer to warn print function
 * @param   F_Printf  debugFunc   Pointer to debug print function
 * @param   F_Printf  infoFunc    Pointer to info print function
 * @return  void
 */
void CDSM_SetPrintFuncs( F_Printf errorFunc, F_Printf warnFunc,
   F_Printf debugFunc, F_Printf infoFunc );

/**
 * @brief   Sets debug print state to select areas of debug
 * @param   U32BIT   state    See defines above
 * @return  void
 */
void CDSM_SetPrintState( U32BIT state );

/**
 * @brief   Set Debug mask for core DSM.
 * @param   dsm DSMCC core instance handle.
 * @param   dbgMask Mask to filter debug messages
 * @return
 */
void CDSM_SetDebugState( H_DsmCoreInst dsm, U32BIT dbgMask );

/*----------------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
#endif /* _DSMDEBUG_H_ */
