/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2002 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   DSM-CC global types header
 *             Used by SI Query and Section Filter code
 * @file    cldsmtypes.h
 * @date    20/02/2002
 * @author  Philips
 */
#ifndef _CLDSMTYPES_H_
#define _CLDSMTYPES_H_

/*---includes for this file--------------------------------------------------*/
#include "dsm_types.h"

/*---Constant and macro definitions for public use---------------------------*/

/* Minimum and Maximum number of section filters required by this DSM-CC module.
 * This is NOT number of PID filters - as there can be many DSM-CC section
 * filters on a single PID.
 * For example, UK DTG MHEG main test suite requires at least 46 section
 * filters, but needs only 2 PID filters for this.
 * Note that to pass MHEG tests, more that 46 is a must!
 */
#define NUM_SECTION_FILTERS_MINIMUM    8
#define NUM_SECTION_FILTERS_DEFAULT    512
#define NUM_SECTION_FILTERS_MAXIMUM    1024

#define INVALID_ASSOCIATION_TAG        0xFFFF

/* ----------- Section Filter Priorities --------- */

/*--------------------------------------------------*/

/*---Enumerations for public use---------------------------------------------*/

typedef enum
{
   /* For DSM-CC sections currently with LOW priority */
   SF_PRIORITY_LOW = 0,
   /* For DSM-CC sections currently with CLEAR priority
    * This is where DSM-CC requires that the section should
    * come direct from transport stream and NOT from any cache
    * It should be treated as low priority, but not
    * necessarily in preference to normal low priority filter */
   SF_PRIORITY_CLEAR = 1,
   /* For DSM-CC sections currently with HIGH priority
    * Must be given in preference to any low priority */
   SF_PRIORITY_HIGH = 2,
   /* For DSM-CC sections currently with DIRECT priority
    * This is where DSM-CC requires that the section should
    * come direct from transport stream and NOT from any cache
    * It should be treated as high priority, but not
    * necessarily in preference to normal high priority filter */
   SF_PRIORITY_DIRECT = 3
} E_SFPriority;

/*---Global type defs for public use-----------------------------------------*/

/* -- DSM-CC ERROR CODES -- */

typedef enum
{
/* 0*/ CLDSM_OK = 0,
/* 1*/ CLDSM_PENDING,
/* 2*/ CLDSM_DUPLICATE_REQUEST,
/* 3*/ CLDSM_ERR_END_OF_DATA,
/* 4*/ CLDSM_ERR_INTERNAL,
/* 5*/ CLDSM_ERR_ABORTED,
/* 6*/ CLDSM_ERR_MEM_HEAP_FULL,
/* 7*/ CLDSM_ERR_ALLOC_FAILED,
/* 8*/ CLDSM_ERR_ILLEGAL_SETUP,
/* 9*/ CLDSM_ERR_ILLEGAL_PARAMETER,
/*10*/ CLDSM_ERR_INVALID_INSTANCE,
/*11*/ CLDSM_ERR_INVALID_CAROUSEL_HANDLE,
/*12*/ CLDSM_ERR_CAROUSEL_LOAD_FAILED,
/*13*/ CLDSM_ERR_CAROUSEL_NOT_BOOTED,
/*14*/ CLDSM_ERR_CAROUSELS_STILL_LOADED,
/*15*/ CLDSM_ERR_INVALID_OBJECT_HANDLE,
/*16*/ CLDSM_ERR_INVALID_OBJECT_TYPE,
/*17*/ CLDSM_ERR_INVALID_PATHNAME,
/*18*/ CLDSM_ERR_INVALID_CACHING_RULES,
/*19*/ CLDSM_ERR_LOAD_FAILED,
/*20*/ CLDSM_ERR_OPEN_OBJECT_LIMIT,
/*21*/ CLDSM_ERR_OBJECT_NOT_LOADED,
/*22*/ CLDSM_ERR_OBJECT_OPEN,
/*23*/ CLDSM_ERR_OBJECT_NOT_OPEN,
/*24*/ CLDSM_ERR_OBJECTS_STILL_LOADED,
/*25*/ CLDSM_ERR_INVALID_STREAM_EVENT_NAME,
/*26*/ CLDSM_ERR_INVALID_STREAM_EVENT_HANDLE,
/*27*/ CLDSM_ERR_STREAM_EVENTS_STILL_SUBSCRIBED,
/*28*/ CLDSM_ERR_NO_STREAM_EVENT_NOTIFY_CALLBACK,
/*29*/ CLDSM_ERR_SI_QUERY_FAILED,
/*30*/ CLDSM_ERR_INVALID_SI_INFO,
/*31*/ CLDSM_ERR_INVALID_SIQUERY_STATUS,
/*32*/ CLDSM_ERR_INVALID_SI_QUERY_REF,
/*33*/ CLDSM_ERR_SYSTEM_ADD_SECTION_FILTER,
/*34*/ CLDSM_ERR_SECTION_FILTER_HEAP_FULL,
/*35*/ CLDSM_ERR_MODULE_TOO_LARGE,
/*36*/ CLDSM_ERR_MODULE_ACQUISITION_FAILURE,
/*37*/ CLDSM_ERR_UNABLE_TO_GET_PROGRAM_ASSOC_TAG,
/*38*/ CLDSM_ERR_NO_CURRENT_SERVICE_SET,
/*39*/ CLDSM_ERR_MEMMGR_START_PROBLEM,
/*40*/ CLDSM_ERR_MEMMGR_STOP_PROBLEM,
/*41*/ CLDSM_ERR_INSTANCE_NOT_RESET,
/*42*/ CLDSM_ERR_RECURSION_LIMIT_REACHED,
/*43*/ CLDSM_ERR_TIMER_FAILURE,
/*44*/ CLDSM_ERR_SI_SUBSCRIBE_FAILURE,
/*45*/ CLDSM_ERR_CAROUSEL_UNAVAILABLE,
} E_DscError;

/* -- DSM-CC INSTANCE HANDLE -- */

typedef struct s_DsmCoreInstance *H_DsmCoreInst;


/* -- SECTION FILTER TYPES -- */

typedef U32BIT H_DscSFRef;

/*
-- Structure definition for Section Filter data
--
-- PID            ->  MPEG2 PID
--
-- filterPriority ->  direct, high or low
--
-- tableId        ->  DSM-CC tableId filter value for sections (byte 0).
--                    NB. Only the tableId values of 0x3B, 0x3C, 0x3D will
--                    be used for DSM-CC section filters.
--
-- tableIdExt     ->  DSM-CC tableIdExtension filter value (bytes 3&4)
--
-- tableIdExtMask ->  DSM-CC active filter bits.
--                    NB.'Wildcard' bitmasks will only be set on contiguous
--                    bits starting at LSBit.
--
*/
typedef struct
{
   U16BIT pid;
   U8BIT priority;
   U8BIT tableId;
   U16BIT tableIdExt;
   U16BIT tableIdExtMask;
} S_SecFilter, *P_SecFilter;

typedef struct s_SfmInstance *H_SfmInstance;

/* -- SI QUERY TYPES -- */

typedef struct s_SIQueryRef *H_SIQueryRef;

typedef enum
{
   /* Following are supplied to startSIQueryFunc() and
    * returned in successful query result */
   SIQUERY_PID,
   SIQUERY_BOOT_CAROUSEL,
   SIQUERY_CAROUSEL,
   SIQUERY_PIDLIST,
   SIQUERY_DEFERRED_SERVICE,
   SIQUERY_CAROUSEL_INFO,
   SIQUERY_FIND_CAROUSEL,
   SIQUERY_SSU_CAROUSEL,
   SIQUERY_SSU_PID,

   /* Below are used in query result when not success - used in
    * return from startSIQueryFunc() or
    * asynchronous callback to CDSM_SysProcessSIQueryEvent()
    */
   SIRESULT_PENDING,
   SIRESULT_FAILURE
} E_SIQueryKind;


typedef struct
{
   E_SIQueryKind kind;
   U16BIT serviceId;
   U16BIT associationTag;
   U32BIT dataId; /* carousel Id, OUI, or componentTag */
} S_SIQueryRequest, *P_SIQueryRequest;


typedef struct s_CarouselInfo
{
   U16BIT pid;
   U16BIT associationTag;
   U32BIT carouselId;
   struct s_CarouselInfo *next;
   /*TODO: ?Format Id?*/
} S_CarouselInfo, *P_CarouselInfo;


typedef struct
{
   E_SIQueryKind kind;

   union
   {
      U16BIT pid;
      S_CarouselInfo carouselInfo;
      S_DvbLocator deferredService;
      /* For when query start returns CLDSM_PENDING */
      void *queryHandle;
   } data;
} S_SIQueryResult, *P_SIQueryResult;


/* -- SI change event -- */
typedef enum
{
   SICHANGE_SERVICE_DELETED,
   SICHANGE_SERVICE_UPDATED,
   SICHANGE_CAROUSEL_DELETED
} E_SIChangeEvent;

typedef struct s_SiqInstance *H_SiqInstance;

typedef union
{
   void *ptr;
   U32BIT u32;
   S32BIT s32;
   U16BIT u16;
   U8BIT u8;
   BOOLEAN b;
} U_PARAM;

#endif /* _CLDSMTYPES_H_ */
