/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2001 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to the cacheMgr module.
 * @file    cacheMgr.h
 * @date    28/9/2001
 * @author  R Taylor
 */
#ifndef _CACHEMGR_H_
#define _CACHEMGR_H_


/*--------------------------------  Includes  --------------------------------*/
#include "clDsmSystem.h"
#include "clDsmMemMgrAPI.h" /*for DBG_STORE_LINE*/


#ifdef __cplusplus
extern "C" {
#endif


/*-----------------------------  Exported Macros  ----------------------------*/

#ifdef DBG_STORE_LINE
#define DSC_CmMemGet(i, s)          DSC_CmMemAlloc(i, s, __LINE__)
#else
#define DSC_CmMemAlloc(i, s, l)     DSC_CmMemGet(i, s )
#endif

/*------------------------------  Exported Types  ----------------------------*/


/*------------------------------  Exported Data  -----------------------------*/


/*---------------------------  Exported Prototypes  --------------------------*/

MemHandle DSC_CmMemAlloc( P_DsmCoreInst idp, U32BIT size, int line );

void DSC_CmMemRelease( P_DsmCoreInst idp, MemHandle hMemArea );

BOOLEAN DSC_CmMemPurgeCache( P_DsmCoreInst idp, U32BIT maxMemory );

/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#endif /* _CACHEMGR_H_ */
