/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2001 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   General include file for clDsm library internal definitions.
 * @file    clDsmSystem.h
 * @date    28/9/2001
 * @author  R Taylor
 */
#ifndef _CLDSMSYSTEM_H_
#define _CLDSMSYSTEM_H_


/*---includes for this file--------------------------------------------------*/

#include "cldsmcc.h"
#include "clDsmMemMgrAPI.h"
#include "dsmDbg.h"

#ifdef __cplusplus
extern "C" {
#endif


/*---Constant and macro definitions for public use---------------------------*/

/* -- Turn off all static declarations in debug mode to enable
   -- glowcode profiler to detect them */
#if (!defined(NDEBUG) && defined(DSM_PROFILING_BUILD))
#define static
#endif

/* -- Context defines */
#ifndef DSM_NO_MEM_CONTEXT
#define MEM_CONTEXT         idp->memContext
#endif


/* -- General purpose defines */

#define BIT0_MSK    0x01
#define BIT1_MSK    0x02
#define BIT2_MSK    0x04
#define BIT3_MSK    0x08
#define BIT4_MSK    0x10
#define BIT5_MSK    0x20
#define BIT6_MSK    0x40
#define BIT7_MSK    0x80

#define BIT8_MSK    0x0100
#define BIT9_MSK    0x0200
#define BIT10_MSK   0x0400
#define BIT11_MSK   0x0800
#define BIT12_MSK   0x1000
#define BIT13_MSK   0x2000
#define BIT14_MSK   0x4000
#define BIT15_MSK   0x8000

#define LSB1_MSK    0x01
#define LSB2_MSK    0x03
#define LSB3_MSK    0x07
#define LSB4_MSK    0x0F
#define LSB5_MSK    0x1F
#define LSB6_MSK    0x3F
#define LSB7_MSK    0x7F
#define LSB8_MSK    0xFF

#define LSB9_MSK    0x01FF
#define LSB10_MSK   0x03FF
#define LSB11_MSK   0x07FF
#define LSB12_MSK   0x0FFF
#define LSB13_MSK   0x1FFF
#define LSB14_MSK   0x3FFF
#define LSB15_MSK   0x7FFF
#define LSB16_MSK   0xFFFF

#define MOD2_MSK    LSB1_MSK
#define MOD4_MSK    LSB2_MSK
#define MOD8_MSK    LSB3_MSK
#define MOD16_MSK   LSB4_MSK
#define MOD32_MSK   LSB5_MSK
#define MOD64_MSK   LSB6_MSK
#define MOD128_MSK  LSB7_MSK



/* -- DSMCC DEFINES */

/* NB. All offsets assume that variable length fields are zero length */

/* -- DSMCC section header defines */
#define DSIDII_ID               0x3B
#define DDB_ID                  0x3C
#define STREAM_DESCR_ID         0x3D

#define SECTION_HDR_LEN         8
#define MIN_SECTION_LEN         9
#define MAX_SECTION_LEN         4093

#define MAX_DDB_BLOCKSIZE       4066

/* -- DSMCC Message Header (dsmccMessageHeader) defines */
#define DSMCC_MSG_HDR_LEN       12

/* -- DSI Message defines */
#define DSI_HDR_LEN             24
#define MIN_SRG_INFO_LEN        (IOR_HDR_LEN + \
                                 PROFILE_TAG_BIOP_HDR_LEN + \
                                 MIN_PROFILE_TAG_BIOP_DATA_LEN)
#define MIN_DSI_MSG_BODY_LEN    (DSI_HDR_LEN + \
                                 MIN_SRG_INFO_LEN)
#define MIN_DSI_MSG_LEN         (DSMCC_MSG_HDR_LEN + DSI_HDR_LEN)

/* -- DII Message defines */

#define MIN_DII_MSG_BODY_LEN    20
#define MIN_DII_MSG_LEN         (DSMCC_MSG_HDR_LEN + \
                                 MIN_DII_MSG_BODY_LEN)

/* -- DDB message defines */
#define DSMCC_DOWNLOAD_HDR_LEN              12
#define DDB_MSG_PAYLOAD_HDR_LEN             6
#define MIN_DDB_PAYLOAD_DATA_LEN            0
#define MIN_DDB_MSG_BODY_LEN                (DDB_MSG_PAYLOAD_HDR_LEN + \
                                             MIN_DDB_PAYLOAD_DATA_LEN)
#define MIN_DDB_MSG_LEN                     (DSMCC_DOWNLOAD_HDR_LEN + \
                                             MIN_DDB_MSG_BODY_LEN)
#define MAX_DDB_BLOCKSIZE                   4066

/* DSMCC Masks */
#define TRANSACTION_ID_UPDATED_MASK 0x00000001
#define TRANSACTION_ID_IDENT_MASK   0x0000fffe
#define TRANSACTION_ID_VERSION_MASK 0x3fff0000
#define TRANSACTION_ID_ORIG_MASK    0xc0000000

/* DSM-CC Object header defines */
#define OBJECT_NUMBYTES_TO_MESSAGE_START    12
#define BIOP_MAGIC                          0x42494F50

/* DSMCC Profile Tags */
#define TAG_LITE_OPTIONS            0x49534f05
#define TAG_BIOP                    0x49534f06
#define TAG_CONN_BINDER             0x49534f40
#define TAG_SERVICE_LOCATION        0x49534f46
#define TAG_OBJECT_LOCATION         0x49534f50

/* IOP::IOR defines */
#define IOR_HDR_LEN                 12

/* BIOP::ProfileBody defines */
#define PROFILE_TAG_BIOP_HDR_LEN        10
#define MIN_PROFILE_TAG_BIOP_DATA_LEN   (MIN_OBJ_LOCATION_LEN + \
                                         MIN_CONN_BINDER_LEN)

/* BIOP::ProfileBody - LiteOptionComponent defines */
#define MIN_OBJ_LOCATION_LEN            15
#define MIN_OBJLOC_COMPONENT_DATA_LEN   (MIN_OBJ_LOCATION_LEN - 5)
#define MIN_CONN_BINDER_LEN             23
#define MIN_CONBIND_COMPONENT_DATA_LEN  (MIN_CONN_BINDER_LEN - 5)


/* Tap use constants */
#define UNKNOWN_USE              ((U16BIT) 0)
#define MPEG_TS_UP_USE           ((U16BIT) 1)  /* MPEG transport upstream from Client */
#define MPEG_TS_DOWN_USE         ((U16BIT) 2)  /* MPEG transport downstream to Client */
#define MPEG_ES_UP_USE           ((U16BIT) 3)  /* MPEG elementary upstream from Client */
#define MPEG_ES_DOWN_USE         ((U16BIT) 4)  /* MPEG elementary downstream to Client */
#define DOWNLOAD_CTRL_USE        ((U16BIT) 5)  /* control request/response */
#define DOWNLOAD_CTRL_UP_USE     ((U16BIT) 6)  /* control request from Client */
#define DOWNLOAD_CTRL_DOWN_USE   ((U16BIT) 7)  /* control response to Client */
#define DOWNLOAD_DATA_USE        ((U16BIT) 8)  /* data request/response */
#define DOWNLOAD_DATA_UP_USE     ((U16BIT) 9)  /* data response upstream from Client */
#define DOWNLOAD_DATA_DOWN_USE   ((U16BIT) 10) /* data block downstream to Client */
#define STR_NPT_USE              ((U16BIT) 11) /* NPT Descriptors */
#define STR_STATUS_AND_EVENT_USE ((U16BIT) 12) /* Stream Mode and Event Descriptors */
#define STR_EVENT_USE            ((U16BIT) 13) /* Stream Event Descriptor */
#define STR_STATUS_USE           ((U16BIT) 14) /* Stream Mode Descriptor */
#define RPC_USE                  ((U16BIT) 15) /* RPC bi-directional */
#define IP_USE                   ((U16BIT) 16) /* IP bi-directional */
#define SDB_CTRL_USE             ((U16BIT) 17) /* control channel for Switched Digital Broadcast */
#define T120_TAP1                ((U16BIT) 18) /* reserved for use and definition by T.120 */
#define T120_TAP2                ((U16BIT) 19) /* reserved for use and definition by T.120 */
#define T120_TAP3                ((U16BIT) 20) /* reserved for use and definition by T.120 */
#define T120_TAP4                ((U16BIT) 21) /* reserved for use and definition by T.120 */
#define BIOP_DELIVERY_PARA_USE   ((U16BIT) 22) /* Module delivery parameters */
#define BIOP_OBJECT_USE          ((U16BIT) 23) /* BIOP objects in Modules */
#define BIOP_ES_USE              ((U16BIT) 24) /* Elementary Stream */
#define BIOP_PROGRAM_USE         ((U16BIT) 25) /* Program */
#define BIOP_DNL_CTRL_USE        ((U16BIT) 26) /* Download control messages */

/* -- objectKind and IOR typeId strings */
#define SRG_STR 0x73726700 /* = "srg\0" */
#define DIR_STR 0x64697200 /* = "dir\0" */
#define FIL_STR 0x66696c00 /* = "fil\0" */
#define STR_STR 0x73747200 /* = "str\0" */
#define STE_STR 0x73746500 /* = "ste\0" */

/* DSMCC Descriptor Tag found in DII moduleInfo and DSI groupInfo */
#define DESCRIPTOR_TYPE_TAG                 ((U8BIT) 1)
#define DESCRIPTOR_NAME_TAG                 ((U8BIT) 2)
#define DESCRIPTOR_INFO_TAG                 ((U8BIT) 3)
#define DESCRIPTOR_MODULE_LINK_TAG          ((U8BIT) 4) /* DII only */
#define DESCRIPTOR_CRC32_TAG                ((U8BIT) 5) /* DII only */
#define DESCRIPTOR_LOCATION_TAG             ((U8BIT) 6)
#define DESCRIPTOR_EST_DOWNLOAD_TIME_TAG    ((U8BIT) 7)
#define DESCRIPTOR_GROUP_LINK_TAG           ((U8BIT) 8) /* DSI only */
#define DESCRIPTOR_COMP_MODULE_TAG          ((U8BIT) 9) /* DII only */
#define DESCRIPTOR_SSU_MODULE_TYPE_TAG      ((U8BIT) 0x0A) /* DII only */
#define DESCRIPTOR_SSU_SUBGROUP_ASS_TAG     ((U8BIT) 0x0B) /* DSI only */
#define DESCRIPTOR_MHP_LABEL                ((U8BIT) 0x70) /* DII only */
#define DESCRIPTOR_MHP_CACHING_PRIORITY     ((U8BIT) 0x71) /* DII only */


/* -- MHEG Profile specific (generally useful) defines */

/* -- Settings for UK MHEG profile 1 = 64 + 1 for null (v1.05, sections 3.11 and 8.3.3.3) */
/* -- BUT Settings for MHP = 254 + 1 for null (ETSI 101 812 (7/2000) section 14.1.4) */
#define MAX_PATH_NAME_SIZE      255     /* -- Including null terminator */

/* -- NB. Smallest path element length is one char + one seperator char
   --     (eg. a/). Subtract one from MAX_PATH_NAME_SIZE for null
   --     terminator and add one to force a round up (since there may
   --     be no seperator char at start) */
#define MAX_DIRECTORY_DEPTH     (((MAX_PATH_NAME_SIZE - 1) + 1) / 2)


/* -- Implementation specific defines */

/* -- Path seperator used for internal path represention only */
#define PATH_SEPERATOR_CHAR     '/'

/* -- Min contiguous memory bytes at start of mem mgr block/mem area */
#define MIN_MEM_BLK_SIZE    256

/* -- Restricted to keep S_ModuleBuilder within MIN_MEM_BLK_SIZE
   -- Currently allows max broadcast (compressed) module size of 3.2MBytes */
#define MAX_BLOCKS_IN_MODULE        1600

/*** TODO: CHECK THIS IS SUFFICIENT IN ALL CASES ***/
#define NUM_INTERNAL_MEM_SEQ_MAX    128

/* -- Number of module acquisition (& decompress) attempts that will be
   -- made before giving up */
#define MAX_MODULE_DECOMPRESS_FAILURES  3


/*
-- Section filter defines
--
-- NOTES:
-- To help detect sections supplied from old (deleted) filters, make section
-- filter heap bigger than max filters so memory not re-used immediately.
--
*/
#define SECTION_FILTER_HEAP_SLACK   16
#define SECTION_FILTER_HEAP_SIZE    (NUM_SECTION_FILTERS_MAX_DEFAULT + \
                                     SECTION_FILTER_HEAP_SLACK)


/* Root Carousel (Update/Object) Linked List IDs - parent is DSM instance */
#define ROOT_CAROUSEL_LIST          0
#define NUM_LISTS_ROOT_CAROUSEL     1

/* Data Carousel Linked List IDs - parent is Root Carousel */
#define OC_DATA_CAROUSEL_LIST       0
#define OC_DII_ACQUIRE_LIST         1
#define NUM_LISTS_DATA_CAROUSEL     2

/* Lite Options Linked List IDs - parent is Object Carousel */
#define OC_LITE_OBJECT_LOAD_LIST    0
#define NUM_LITE_OBJECT_LOAD_LIST   1

/* Module Linked List IDs - parent is Data Carousel */
#define DC_MODULE_LIST              0
#define MODULE_ACQUIRE_LIST         1
#define MODULE_PRIORITY_LIST        2
#define MODULE_LOADED_LIST          2
#define MODULE_DELETE_LIST          2
#define NUM_LISTS_MODULE            3

/* Object Linked List IDs */
#define CURR_OBJECT_LIST            0
#define MODULE_OBJECT_LIST          1   /* -- Currently not used */
#define NUM_LISTS_OBJECT            2

/* Load Request Linked List IDs */
#define CURR_LOAD_REQUEST_LIST      0
#define MODULE_LOAD_REQUEST_LIST    1
#define NUM_LISTS_LOAD_REQUEST      2

/* SI Query Linked List IDs */
#define CURR_SI_QUERY_LIST          0
#define DUPLICATE_SI_QUERY_LIST     1
#define NUM_LISTS_SI_QUERY          2

/*
-- General purpose debug check and action macro (disabled by NDEBUG)
--
-- condn        = valid condition to be checked for error (eg. err == CLDSM_OK )
-- dbgErrActn   = command(s) to execute on error condition in debug builds
*/

#ifdef NDEBUG
    #define DEBUG_CHK( condn, dbgActn )
#else
    #define DEBUG_CHK( condn, dbgActn )     if (!(condn)) { dbgActn; }
#endif



/*
-- Macro to provide API parameter checking that can be disabled in retail
-- builds if required (via DSM_NO_API_PARAM_CHECK)
--
-- API parameter checking in retail builds is enabled by default (ie. if
-- DSM_NO_API_PARAM_CHECK is not defined).
--
-- condn        = valid condition to be checked for error (eg. err == CLDSM_OK )
-- dbgErrActn   = command(s) to execute on error condition in debug builds
-- relErrActn   = command(s) to execute on error condition in all builds
--                *** NB. dbgErrActn always executed before relErrActn ***
--
*/
#ifdef DSM_NO_API_PARAM_CHECK

/* -- API parameter checking in debug builds only */

    #ifdef NDEBUG

        #define API_PARAM_CHK( condn, dbgErrActn, relErrActn )

    #else

        #define API_PARAM_CHK( condn, dbgErrActn, relErrActn )  \
   if (!(condn)) { dbgErrActn; }                     \

    #endif

#else

/* -- API parameter checking in all builds (default) */

    #define API_PARAM_CHK( condn, dbgErrActn, relErrActn )      \
   if (!(condn)) { dbgErrActn; relErrActn; }             \

#endif



/*
-- These macro definitions provide three 'priority' levels (0, 1, 2) of
-- general purpose data error checking.
-- The highest priority (0) is always performed and cannot be disabled, the
-- lower two priorities can be optionally disabled for retail mode (at compile
-- time).
--
-- The lower priority levels (2 or 1 & 2) can be enabled/disabled for retail
-- builds (via DSM_DATA_CHECK_LEVEL).
--
-- Both lower levels (1 & 2) of checking are always enabled in debug mode
--
-- The default data check level in retail builds is level 1 (ie. if
-- DSM_DATA_CHECK_LEVEL is not defined).
--
-- Syntax is:
-- L<level>_DATA_CHK( condn, dbgErrActn, relErrActn )
--
-- <lvl>    = 1 - Level 1 priority checking only
-- <lvl>    = 2 - Level 1 and level 2 checking
--
-- condn        = valid condition to be checked for error (eg. err == CLDSM_OK )
-- dbgErrActn   = command(s) to execute on error condition in debug builds
-- relErrActn   = command(s) to execute on error condition in all builds
--                *** NB. dbgErrActn always executed before relErrActn ***
--
*/
#if !defined(DSM_DATA_CHECK_LEVEL)
    #define DSM_DATA_CHECK_LEVEL    1
#endif


/* -- Level 0 data checking always performed */

#define L0_DATA_CHK( condn, dbgErrActn, relErrActn )    \
   if (!(condn)) { dbgErrActn; relErrActn; }         \


#if DSM_DATA_CHECK_LEVEL >= 1

/* -- Level 1 data checking in all builds (default) */

    #define L1_DATA_CHK( condn, dbgErrActn, relErrActn )    \
   if (!(condn)) { dbgErrActn; relErrActn; }         \

#else

/* -- Level 1 data checking in debug builds only */

    #if (defined(NDEBUG) || defined(DSM_PROFILING_BUILD))

        #define L1_DATA_CHK( condn, dbgErrActn, relErrActn )

    #else

        #define L1_DATA_CHK( condn, dbgErrActn, relErrActn ) \
   if (!(condn)) { dbgErrActn; }                 \

    #endif

#endif


#if DSM_DATA_CHECK_LEVEL >= 2

/* -- Level 2 data checking in all builds */

    #define L2_DATA_CHK( condn, dbgErrActn, relErrActn )    \
   if (!(condn)) { dbgErrActn; relErrActn; }         \

#else

/* -- Level 2 data checking in debug builds only (default) */

    #if (defined(NDEBUG) || defined(DSM_PROFILING_BUILD))

        #define L2_DATA_CHK( condn, dbgErrActn, relErrActn )

    #else

        #define L2_DATA_CHK( condn, dbgErrActn, relErrActn ) \
   if (!(condn)) { dbgErrActn; }                 \

    #endif

#endif



/* In debug only, this macro checks for error codes returned from memory API
   functions */
#ifndef NDEBUG
#define CHECK_MEM_ERR( func )                           \
   {                                                   \
      E_DsmMemErr memErr;                                  \
                                                        \
      memErr = func;                                  \
      if (memErr != MEM_NO_ERR) {                     \
         dsmDP1(("Memory error : %i \n", memErr)); \
         dsmAssert((memErr == MEM_NO_ERR));        \
      }                                               \
   }

#else
#define CHECK_MEM_ERR( x ) x
#endif


/*---Enumerations for public use---------------------------------------------*/

typedef enum
{
   PTYP_INIT  = 0x00,
   PTYP_FIRST = 0x01,
   PTYP_INTER = 0x02,
   PTYP_LAST  = 0x03
} E_PostionType;

/*---Global type defs for public use-----------------------------------------*/


/* Object Location Types */
typedef struct
{
   U8BIT length;
   U8BIT data[4];
} S_ObjectKey, *P_ObjectKey;


typedef struct
{
   U32BIT carouselId;
   U16BIT moduleId;
   S_ObjectKey objectKey;
   U32BIT uiBindingTag;
   U8BIT dvbCarouselNSAPaddress[20];
#ifdef READ_COSNAMING
   S8BIT pathName[65];
#endif
} S_ObjectLocation, *P_ObjectLocation;


/* Tap Types */
typedef struct
{
   /* use = BIOP_DELIVERY_PARA_USE */
   U16BIT id;
   U16BIT associationTag;
   U32BIT transactionId;
   U32BIT timeout;
} S_DeliveryParaTap, *P_DeliveryParaTap;


typedef struct s_LLControl *P_LLControl;
typedef struct s_se_info *ps_se_info;

typedef struct s_ObjectCarousel *P_ObjectCarousel;
typedef struct s_RootCarousel *P_RootCarousel;
typedef struct s_DataCarousel *P_DataCarousel;
typedef struct s_Module *P_Module;
typedef struct s_dsmevent *P_Event;
typedef struct s_SiQuery *P_SiQuery;
typedef struct s_RootLoadRqst *P_RootLoadRqst;
typedef struct s_ModuleData *P_ModuleData;
typedef struct s_ZlibHeap *P_ZlibHeap;

/*
-- Structure type for DSM-CC Core Layer instance data
*/

typedef struct s_DsmCoreInstance
{
   /* -- SETUP DATA (COPY) */
   S_DsmSetup setup;

   /* -- Recursion depth counters for specific functions */
   U32BIT pfrdoCallDepth;       /* -- For preFetchRelativeDirObj() */
   U32BIT pfdlfCallDepth;       /* -- For preFetchDirLoadFinalise() */
   U32BIT pfsdndCallDepth;      /* -- For preFetchSubDirsAndNewDIIsFromLoadedDir() */

   /* -- Store for memory manager context (from memStart) */
   void *memContext;

   /* -- Store for current service info */
   S_DvbLocator dvbLocator;
   BOOLEAN currentServiceSet;
   BOOLEAN cacheFull;

   /* -- Store for SI query results */
   BOOLEAN lastPIDResultStored;
   U16BIT lastServiceId;
   U16BIT lastAssociationTag;
   U16BIT lastPID;

#ifndef NDEBUG
   U16BIT dbgMask;
#endif

   /* -- Generation counter for siQuery results and sections */
   U_PARAM generation;

   /* -- Monitor cache memory usage */
   U32BIT cacheMemoryUsage;
   U32BIT cacheMaximumUsage;

   /* -- Store of number of objects currently opened by clients */
   /* TODO: Should be stored in OC when multi-carousel supported */
   U32BIT dsmObjectsOpen;

   /* -- Handle to section filter heap memory */
   void *sectionFilterHeap;

   /* -- zlib heap memory (for module decompress) */
   P_ZlibHeap pZlibHeap;

   P_RootCarousel pCurrentCarousel;
   P_RootCarousel pBootingCarousel;

   P_LLControl llcRootCarousels;
   P_LLControl llcModulePriority;
   P_LLControl llcLoadedModules;
   P_LLControl llcExpiredModules;
   P_LLControl llcCurrLoadRequests;
   P_LLControl llcCurrSiQueries;

   ps_se_info hSubscribedEventList;
} S_DsmCoreInst, *P_DsmCoreInst;

/*------------------------------  Exported Data  -----------------------------*/


/*---------------------------  Exported Prototypes  --------------------------*/

E_DscError CDSM_UnloadAllObjects( P_DsmCoreInst instance, E_DsmRstMode mode );

/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#endif /* _CLDSMSYSTEM_H_ */
