/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2001 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to the dataCarousel module - functions/methods for
 *             creating/destroying and managing attributes of DSM-CC data carousels.
 * @file    dataCarousel.h
 * @date    28/9/2001
 * @author  R Taylor
 */
#ifndef _DATACAROUSEL_H_
#define _DATACAROUSEL_H_


/*--------------------------------  Includes  --------------------------------*/

#include "clDsmSystem.h"

#include "linkList.h"
#include "module.h"

#ifdef __cplusplus
extern "C" {
#endif


/*-----------------------------  Exported Macros  ----------------------------*/

#define INVALID_TRANSIDVER 0xFFFF
#define DC_IN_OC(pDC)   \
   (DSC_RootCrslMagic(LLParent(pDC, OC_DATA_CAROUSEL_LIST)) == OC_MAGIC) ? TRUE : FALSE
#define MAKE_MODULE_REF(dlid,mid)   (((U32BIT)dlid) << 16 | mid)

/*------------------------------  Exported Types  ----------------------------*/

typedef struct
{
   U16BIT blockSize;
   U16BIT numberOfModules;    /* -- NB. Value stored here not currently used */
} DiiInfo_t, *pDiiInfo_t;


typedef struct s_DataCarousel
{
   S_LLObject llData[NUM_LISTS_DATA_CAROUSEL];
   U16BIT dataCarouselId;
   U16BIT transIdver;
   U32BIT diiCrc;

   /* -- DII filter info */
   S_DeliveryParaTap tap;
   P_SecFilterInfo pDiiSf;

   U16BIT diiRequestCount;
   U16BIT diiMonitorCount;

   DiiInfo_t diiInfo;
   U16BIT diiMsgDataLen;
   MemPtr hDiiMsgData;

   P_LLControl llcDcModules;
   P_LLControl llcModuleAcquires;
   P_LLControl llcLoadRequests;
} S_DataCarousel;


/*------------------------------  Exported Data  -----------------------------*/


/*---------------------------  Exported Prototypes  --------------------------*/

E_DscError DSC_DataCrslCreate( P_DsmCoreInst idp, P_RootCarousel pRC,
   P_DeliveryParaTap pTap, P_DataCarousel *ppDataCarousel );

void DSC_DataCrslDestroy( P_DsmCoreInst idp, P_DataCarousel pDC );

void DSC_DataCrslDelete( P_DsmCoreInst idp, P_DataCarousel pDC );

P_DataCarousel DSC_DataCrslListFindById( P_LLControl pDcList, U32BIT transactionId );

E_DscError DSC_DataCrslAcquireStart( P_DsmCoreInst idp, P_DataCarousel pDC, E_SFPriority sfPriority );
E_DscError DSC_DataCrslAcquireRestart( P_DsmCoreInst idp, P_DataCarousel pDC );
void DSC_DataCrslAcquireStop( P_DsmCoreInst idp, P_DataCarousel pDC, E_SFPriority sfPriority );

U16BIT DSC_DataCrslGetServiceId( P_DataCarousel pDC );
U16BIT DSC_DataCrslGetPid( P_DataCarousel pDC );

P_Module DSC_DataCrslFirstModule( P_DataCarousel pDC );

BOOLEAN DSC_DataCrslSsuModuleUpdate( P_DsmCoreInst idp, P_Module pModule );

void DSC_DataCrslUnloadModule( P_DsmCoreInst idp, P_DataCarousel pDC,
   U16BIT moduleId );

E_DscError DSC_DataCrslNewModuleLoad( P_DsmCoreInst idp, P_DataCarousel pDC, P_Module pModule );

E_DscError DSC_DataCrslUpdate( P_DsmCoreInst idp, P_DataCarousel pDC, U32BIT transactionId,
   U8BIT *pDiiMsg, U16BIT diiMsgDataLen );

void DSC_DataCrslCheckSsuStatus( P_DsmCoreInst idp, P_DataCarousel pDC );

/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#endif /* _DATACAROUSEL_H_ */
