/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2001 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Defines memory access utils to work with contiguous memory.
 * @file    defMemUtilsContig.h
 * @date    28/9/2001
 * @author  R Taylor
 */
/*---Includes for this header------------------------------------------------*/
#include <string.h>
#include "clDsmUtils.h"

/*---Constant and macro definitions for public use-----------------------------*/

/* -- SET STANDARD MACROS TO ACCESS CONTIGUOUS MEMORY */

#undef  MemPtr
#undef  MemPos
#undef  MEMPTR_SEQ_OPEN
#undef  MEMPTR_SEQ_CLOSE
#undef  MEMPTR_OPEN
#undef  MEMPTR_CLOSE
#undef  MEMPTR_GET_DIFF
#undef  MEMPTR_DATA_COMPARE
#undef  MEMPTR_READ
#undef  MEMPTR_WRITE
#undef  MEMPTR_COPY
#undef  SET_POS_REL
#undef  SET_POS_ABS
#undef  GET_POS
#undef  READ_UINT8
#undef  READ_UINT16
#undef  READ_UINT32
#undef  GET_UINT8
#undef  GET_UINT16
#undef  GET_UINT32
#undef  READ_OBJECT_KEY


#define MemPtr  PU8BIT
#define MemPos  PU8BIT

#define MEMPTR_SEQ_OPEN( context, memArea, offset, length, async, memPtr )  \
   memPtr = memArea;                                        \
   memPtr += offset

#define MEMPTR_SEQ_CLOSE( context, memArea, memPtr )

#define MEMPTR_OPEN( seqMemPtr, memPtr )                    \
   memPtr = seqMemPtr

#define MEMPTR_CLOSE( memPtr )

#define MEMPTR_GET_DIFF( memPtr1, memPtr2, i32 )            \
   i32 = (memPtr2 - memPtr1)

#define MEMPTR_DATA_COMPARE( ui8Ptr, memPtr, length, equal ) \
   equal = ((memcmp( ui8Ptr, memPtr, length ) != 0) ? FALSE : TRUE)

#define MEMPTR_READ( srcMemPtr, destUi8Ptr, numbytes )      \
   memcpy( destUi8Ptr, srcMemPtr, numbytes )

#define MEMPTR_WRITE( srcUi8Ptr, destMemPtr, numbytes )     \
   memcpy( destMemPtr, srcUi8Ptr, numbytes )

#define MEMPTR_COPY( srcMemPtr, destMemPtr, numbytes )      \
   memcpy( destMemPtr, srcMemPtr, numbytes )

#define SET_POS_REL( memPtr, offset )   (memPtr += offset)
#define SET_POS_ABS( memPtr, memPos )   (memPtr = memPos)
#define GET_POS( memPtr, memPos )       (memPos = memPtr)

#define READ_UINT8( memPtr, ui8 )       READ_UINT8_C( memPtr, ui8 )
#define READ_UINT16( memPtr, ui16 )     READ_UINT16_C( memPtr, ui16 )
#define READ_UINT24( memPtr, ui32 )     READ_UINT24_C( memPtr, ui32 )
#define READ_UINT32( memPtr, ui32 )     READ_UINT32_C( memPtr, ui32 )
#define GET_UINT8( memPtr, ui8 )        GET_UINT8_C( memPtr, ui8 )
#define GET_UINT16( memPtr, ui16 )       GET_UINT16_C( memPtr, ui16 )
#define GET_UINT32( memPtr, ui32 )      GET_UINT32_C( memPtr, ui32 )

#define READ_OBJECT_KEY( memPtr, objKey, valid )    \
   READ_OBJECT_KEY_C( memPtr, objKey, valid )


/*----------------------------------------------------------------------------*/

