/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2001 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Defines memory access utils to work with managed (MemMgr) memory.
 * @file    defMemUtilsMgd.h
 * @date    28/9/2001
 * @author  R Taylor
 */
#ifdef MEM_CONTIGUOUS

/*
-- Managed memory is CONTIGUOUS so can access via standard pointer
-- manipulation
*/
    #include "defMemUtilsContig.h"

#else

/* -- SET STANDARD MACROS TO ACCESS MANAGED/MEMSEQ MEMORY */

    #undef  MemPtr
    #undef  MemPos
    #undef  MEMPTR_SEQ_OPEN
    #undef  MEMPTR_SEQ_CLOSE
    #undef  MEMPTR_OPEN
    #undef  MEMPTR_CLOSE
    #undef  MEMPTR_GET_DIFF
    #undef  MEMPTR_DATA_COMPARE
    #undef  MEMPTR_READ
    #undef  MEMPTR_WRITE
    #undef  MEMPTR_COPY
    #undef  SET_POS_REL
    #undef  SET_POS_ABS
    #undef  GET_POS
    #undef  READ_UINT8
    #undef  READ_UINT16
    #undef  READ_UINT32
    #undef  GET_UINT8
    #undef  GET_UINT16
    #undef  GET_UINT32
    #undef  READ_OBJECT_KEY


    #define MemPtr  MemSeqRef
    #define MemPos  U32BIT

    #define MEMPTR_SEQ_OPEN( context, memArea, offset, length, async, memPtr ) \
   CHECK_MEM_ERR(                                                        \
   memSeqOpen(context, memArea, offset, length, async, &(memPtr)))

    #define MEMPTR_SEQ_CLOSE( context, memArea, memPtr )    \
   memSeqClose( memPtr )

    #define MEMPTR_OPEN( seqMemPtr, memPtr )                \
   CHECK_MEM_ERR(memSeqOpenClone( seqMemPtr, &(memPtr)))

    #define MEMPTR_CLOSE( memPtr )  memSeqClose( memPtr )

    #define MEMPTR_GET_DIFF( memPtr1, memPtr2, i32 )        \
   {                                                   \
      U32BIT pos1, pos2;                             \
      memSeqReadPos( memPtr1, &(pos1));                \
      memSeqReadPos( memPtr2, &(pos2));                \
      i32 = pos2 - pos1;                              \
   }

    #define MEMPTR_DATA_COMPARE( ui8Ptr, memPtr, length, equal )                    \
   CHECK_MEM_ERR(memSeqCompContig( ui8Ptr, memPtr, length, &(equal)))

    #define MEMPTR_READ( srcMemPtr, destUi8Ptr, numbytes )                          \
   {                                                                           \
      U32BIT dummy;                                                           \
      CHECK_MEM_ERR(memSeqRead( srcMemPtr, destUi8Ptr, numbytes, &dummy ));   \
   }

    #define MEMPTR_WRITE( srcUi8Ptr, destMemPtr, numbytes )                         \
   {                                                                           \
      U32BIT dummy;                                                           \
      CHECK_MEM_ERR(memSeqWrite( srcUi8Ptr, destMemPtr, numbytes, &dummy ));  \
   }

    #define MEMPTR_COPY( srcMemPtr, destMemPtr, numbytes )                          \
   {                                                                           \
      U32BIT dummy;                                                           \
      CHECK_MEM_ERR(memSeqCopy( srcMemPtr, destMemPtr, numbytes, &dummy ));   \
   }

    #define SET_POS_REL( memPtr, offset )                   \
   CHECK_MEM_ERR(memSeqSetPosRel( memPtr, offset ))

    #define SET_POS_ABS( memPtr, memPos )                   \
   CHECK_MEM_ERR(memSeqSetPosAbs( memPtr, memPos ))

    #define GET_POS( memPtr, memPos )                       \
   memSeqReadPos( memPtr, &(memPos))

    #define READ_UINT8( memPtr, ui8 )                       \
   CHECK_MEM_ERR(memSeqReadByte( memPtr, &(ui8)))

    #define READ_UINT16( memPtr, ui16 )     readUInt16Seq( memPtr, &(ui16))
    #define READ_UINT32( memPtr, ui32 )     readUInt32Seq( memPtr, &(ui32))
    #define GET_UINT8( memPtr, ui8 )        getUInt8Seq( memPtr, &(ui8))
    #define GET_UINT16( memPtr, ui16 )      getUInt16Seq( memPtr, &(ui16))
    #define GET_UINT32( memPtr, ui32 )      getUInt32Seq( memPtr, &(ui32))

    #define READ_OBJECT_KEY( memPtr, objKey, valid )          \
   readObjectKeySeq( memPtr, &(objKey), &(valid))


#endif

/*----------------------------------------------------------------------------*/

