/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2002 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to dsmObject module - functions for managing DSM object heap
 * @file    dsmObject.h
 * @date    1/2/2002
 * @author  N Kirkland
 */
#ifndef _DSMOBJECT_H_
#define _DSMOBJECT_H_


/*---includes for this file--------------------------------------------------*/

#include "clDsmSystem.h"
#include "linkList.h"
#include "object.h"

#ifdef __cplusplus
extern "C" {
#endif


/*---Constant and macro definitions for public use---------------------------*/


#define DSM_OBJECT_MAGIC    0xF1D3B597

#define DSM_OBJECT_VALIDATE( pDsmObject )   \
   (pDsmObject->magic == DSM_OBJECT_MAGIC && pDsmObject->myDsmInst)

#define DSM_OBJECT_CORRECT( pDsmObject, idp )   \
   (pDsmObject->magic == DSM_OBJECT_MAGIC && pDsmObject->myDsmInst == idp)

#define DEFFERED_SERVICE_RECEIVED  0xD0FE

/*---Global type defs for public use-------------------------------------------*/

typedef struct s_DsmObject *P_DsmObject;


typedef struct s_DsmObject
{
   S_LLObject llData[NUM_LISTS_OBJECT];

   U32BIT magic;
   P_DsmCoreInst myDsmInst;

   E_ObjLoadStatus status;

   E_CacheRules cachingRules;

   E_DsmObjectKind kind;

   P_ObjectCarousel pObjCarousel;
   P_Module pModule;
   P_ModuleData hModuleData;

   ObjectDataInfo_t objectInfo;
   U32BIT objectDataOffset;
   MemSeqRef objectDataSeq;

   /* Use of below depends on 'status' */
   union
   {
      void* pLoadRequest;              /* non-NULL when (status == OBJ_LOAD_IN_PROGRESS) */
      void* pPendingSiQueryRef;        /* non-NULL when (status == OBJ_LOAD_COMPLETED) and getting deferred service */
   } r;

   /* Use of below depends on 'kind', and only valid when (status == OBJ_LOAD_COMPLETED) */
   union
   {
      /* deferred service query - temporary held data, while (pPendingSiQueryRef != NULL) */
      struct
      {
         void *userData1;
         void *userData2;
      } ds;

      /* stream object, deferred service */
      struct
      {
         S_DvbLocator multiplex;
         U16BIT retrieved;
      } so;
   } data;
} S_DsmObject;

/*---Global variable declarations for public use-----------------------------*/

/*---Global Function prototypes for public use---------------------------------*/

E_DscError objectCreate( P_DsmCoreInst idp, P_DsmObject *ppObject );

void objectDestroy( P_DsmCoreInst idp, P_DsmObject pObject );


/*----------------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
#endif /* _DSMOBJECT_H_ */
