/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2001 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Common source code to find module info descriptor in DII.
 *             To be included by functions processing data in contiguous or managed
 *             (MemSeq) memory.
 * @file    findModuleInDii_include_src.h
 * @date    28/9/2001
 * @author  R Taylor
 */

/*
-- findModuleInDiiMsg - Common Code
--
-- Find start of requested module in DII message (compatible with
-- contiguous or managed/MemSeq memory)
--
-- Uses/assumes the following vars:
--      found, mpDiiMsg, dataLength, *mpModuleInfoDescStart
--
-- mpDiiMsg references ('points' to) first byte of DIIMessageBody,
-- found (BOOLEAN) indicates whether module descriptor was found
--
-- mpDiiMsg                 = const U8BIT* or MemSeqRef,
-- dataLength               = U32BIT
-- mpModuleInfoDescStart    = *U8BIT* or *MemSeqRef
-- found                    = BOOLEAN
*/

{
   MemPtr mpModuleInfoDesc;
   U16BIT numModules;
   U16BIT currModuleId;
   MemPos moduleDataEnd = 0;
   MemPos currStartPos = 0;
   U8BIT moduleInfoLength;

   dsmAssert((mpDiiMsg != NULL));
   dsmAssert((dataLength > 0));
   dsmAssert((mpModuleInfoDescStart != NULL));


   found = FALSE;

   /* -- Open MemPtr for accessing module info in DII message */
   MEMPTR_OPEN( mpDiiMsg, mpModuleInfoDesc );

   /* -- mpModuleInfo -> DIIMessageBody */

   /* -- Skip downloadId, blockSize - not used here */
   SET_POS_REL( mpModuleInfoDesc, 6 );

   /* -- Skip windowSize, ackPeriod, tCDownloadWindow, tCDownloadScenario,
      -- compatibilityDescriptor - unused in DVB OC */
   SET_POS_REL( mpModuleInfoDesc, 12 );

   /* -- Read numberOfModules */
   READ_UINT16( mpModuleInfoDesc, numModules );

   /* -- Calculate end position of module data */
   GET_POS( mpModuleInfoDesc, moduleDataEnd );
   moduleDataEnd += dataLength;

   /* -- Loop through module descriptors until we find the right one */
   while (numModules--)
   {
      /* -- mpModuleInfo -> start of module descriptor */

      /* -- Remember start position of this module descriptor */
      GET_POS( mpModuleInfoDesc, currStartPos );

      /* -- Check for end of module data */
      if (currStartPos >= moduleDataEnd)
      {
         break;
      }

      /* -- Read moduleId */
      READ_UINT16( mpModuleInfoDesc, currModuleId );

      if (currModuleId == moduleId)
      {
         found = TRUE;
         break;
      }

      /* -- Skip moduleSize, moduleVersion */
      SET_POS_REL( mpModuleInfoDesc, 5 );

      /* -- Read moduleInfoLength */
      READ_UINT8( mpModuleInfoDesc, moduleInfoLength );

      /* -- Skip objectInfo */
      SET_POS_REL( mpModuleInfoDesc, (S32BIT)moduleInfoLength );
   }

   if (found)
   {
      SET_POS_ABS( *mpModuleInfoDescStart, currStartPos );
   }

   MEMPTR_CLOSE( mpModuleInfoDesc );
}


/*----------------------------------------------------------------------------*/



