/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2001 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to the linkList module - Functions/methods for managing linked
 *             lists of items created in managed (memMgr) memory.
 * @file    linkList.h
 * @date    28/9/2001
 * @author  R Taylor
 */
#ifndef _LINKLIST_H_
#define _LINKLIST_H_


/*--------------------------------  Includes  --------------------------------*/
#include "clDsmSystem.h"

#ifdef __cplusplus
extern "C" {
#endif


/*-----------------------------  Exported Macros  ----------------------------*/


/*------------------------------  Exported Types  ----------------------------*/
typedef U16BIT ListId_t;

typedef struct s_LLObject *P_LLObject;
typedef void *H_Object;

typedef struct s_LLObject
{
   P_LLControl pLLCtrl;
   P_LLObject pNext;
   P_LLObject pPrev;
} S_LLObject;


typedef struct s_LLControl
{
   P_LLObject pHead;
   P_LLObject pTail;
   ListId_t listId;
   U16BIT count;
   H_Object hParent;
} S_LLControl;


/*------------------------------  Exported Data  -----------------------------*/


/*---------------------------  Exported Prototypes  --------------------------*/

/* LinkList Control Block functions */
void LLCtrlBlockInit( P_LLControl pCtrl, ListId_t listId, H_Object hParent );

E_DscError LLCreate( P_DsmCoreInst idp,
   H_Object hParent, ListId_t listId, P_LLControl *phLlCtrl );

void LLDestroy( P_DsmCoreInst idp, P_LLControl *phLlCtrl );

H_Object LLHead( P_LLControl pCtrlObj );
H_Object LLTail( P_LLControl pCtrlObj );

BOOLEAN LLInsertHead( P_LLControl pCtrlObj, H_Object hNewObj );
BOOLEAN LLInsertTail( P_LLControl pCtrlObj, H_Object hNewObj );

H_Object LLRemoveHead( P_LLControl pCtrlObj );
H_Object LLRemoveTail( P_LLControl pCtrlObj );

U16BIT LLCount( P_LLControl pCtrlObj );
U16BIT LListId( P_LLControl pCtrlObj );

/* LinkList object functions */
void llLinkInit( P_LLObject pLinks, U32BIT numLists );

BOOLEAN LLRemove( H_Object hListObj, ListId_t listId );
void LLRemoveFromAll( H_Object hListObj, U16BIT numLists );

H_Object LLNext( H_Object obj, ListId_t listId );
H_Object LLPrev( H_Object obj, ListId_t listId );

void LLReplaceAll( H_Object oldobj, H_Object newobj, U16BIT numLists );

BOOLEAN LLCheckInListCtrl( P_LLControl pCtrlBlk, H_Object obj );
BOOLEAN LLCheckInListId( ListId_t listId, H_Object obj );
BOOLEAN LLIsObjectInList( P_LLControl pCtrlBlk, H_Object obj );

H_Object LLParent( H_Object obj, ListId_t listId );


/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#endif /* _LINKLIST_H_ */
