/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2001 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to the loadMgr module.
 * @file    loadMgr.h
 * @date    28/9/2001
 * @author  R Taylor
 */
#ifndef _LOADMGR_H_
#define _LOADMGR_H_


/*--------------------------------  Includes  --------------------------------*/
#include "loadRqst.h"

#include "object.h"
#include "dsmObject.h"
#include "objectCarousel.h"

#ifdef __cplusplus
extern "C" {
#endif

/*-----------------------------  Exported Macros  ----------------------------*/

#define CRSL_LOAD_TIMEOUT    50000

/*------------------------------  Exported Types  ----------------------------*/

typedef struct s_LoadRequest *P_LoadRequest;

typedef struct s_LoadRequest
{
   S_RootLoadRqst rlr;

   P_ObjectCarousel pObjCarousel;          /* -- OC this load is requested on */

   P_DataCarousel pDataCarousel;            /* -- DC that load is currently progressed to */
   P_Module pModule;                        /* -- Module that load is currently progressed to */

   S_DeliveryParaTap tap;                   /* -- Next tap that load needs */
   S_ObjectLocation objectLocation;         /* -- Next object that load needs */

   U32BIT targetObjectOffset;               /* -- NB. From start of moduleData */
   ObjectDataInfo_t targetObjectInfo;

   U32BIT remainingPathOffset;
   U8BIT *pRemainingPath;

} S_LoadRequest;


/*------------------------------  Exported Data  -----------------------------*/


/*---------------------------  Exported Prototypes  --------------------------*/
#ifdef DSM_NO_MEM_CONTEXT
#define lmSetModuleCachingRules( x, a, b )  lmSetModuleCachingRules( a, b )
#endif

E_DscError lmCarouselLoadCreate( P_DsmCoreInst idp, P_ObjectCarousel pOC,
   U32BIT timeout, MemHandle *phLoadRequest );

E_DscError lmUpdateCarouselBoot( P_DsmCoreInst idp, P_ObjectCarousel pOC,
   P_CarouselInfo pCarouselInfo );


E_DscError lmRequestObjectLoad( P_DsmCoreInst idp,
   P_ObjectCarousel pOC, U8BIT *path, U32BIT timeout,
   H_ObjUserData pUserData, U32BIT sizeOfUserData,
   P_DsmObject pDsmObject,
   P_LoadRequest *ppLoadRequest );

E_DscError lmPrefetchObjectLoad( P_DsmCoreInst idp,
   P_ObjectCarousel pOC, U8BIT *path, U32BIT timeout,
   P_LoadRequest *ppLoadRequest );

void lmLoadDestroy( P_DsmCoreInst idp, P_LoadRequest pLoadRequest );

E_DscError lmGetObjectLoadState( P_DsmCoreInst idp,
   P_ObjectCarousel pOC, U8BIT *path, P_Module *ppModule );

E_DscError lmUpdateCarouselSRGInfo( P_DsmCoreInst idp,
   P_ObjectCarousel pOC, P_DeliveryParaTap pSrgTap,
   P_ObjectLocation pSrgLocn );

E_DscError lmUpdateModule( P_DsmCoreInst idp, P_Module pModule );

void lmStopModuleLoadRequest( P_DsmCoreInst idp, P_LoadRequest pLoadRequest );

void lmSetObjectModuleLoaded( P_DsmCoreInst idp, P_Module pModule );

void lmSetObjectModuleUnloaded( P_DsmCoreInst idp, P_Module pModule );

void lmObjCarouselTimeout( P_DsmCoreInst idp, P_ObjectCarousel pOC );

void lmAbortLoadRequestsOnModuleTimeout( P_DsmCoreInst idp, P_Module pModule );

E_DscError lmLiteOptionsObjectHandle(P_DsmCoreInst idp,
   U8BIT *name,
   P_LoadRequest pLoadRequest );

void lmCarouselLoadFinalise( P_DsmCoreInst idp, P_LoadRequest pLoadRequest );

/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#endif /* _LOADMGR_H_ */
