/*******************************************************************************
 * Copyright  2015 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header defining
 * @file    loadRqst.h
 * @date    19/02/2015
 * @author  Adam Sturtridge
 */

#ifndef _LOADRQST_H_
#define _LOADRQST_H_

/*--------------------------------  Includes  --------------------------------*/
#include "clDsmSystem.h"
#include "linkList.h"

#ifdef __cplusplus
extern "C" {
#endif

/*-----------------------------  Exported Macros  ----------------------------*/

#define LOAD_REQUEST_MAGIC   0x4C525154 /*'LRQT'*/

/*------------------------------  Exported Types  ----------------------------*/

typedef enum
{
   LRS_INITIAL = 0,
   LRS_STALLED_DSI,
   LRS_STALLED_SRG_MODULE,
   LRS_STALLED_MODULE,
   LRS_ABORTED_TIMEOUT,
   LRS_ABORTED_PATH_ERROR,
   LRS_ABORTED_LOAD_ERROR,
   LRS_ABORTED_BY_REQUESTER,
   LRS_LOADING,
   LRS_LOADED,
   LRS_LITE_OPTIONS_LOADED,
   LRS_LITE_OPTIONS_PENDING,
   LRS_ABORT_PENDING_RELOAD
} E_LRStatus;

typedef enum
{
   TT_NONE,
   TT_CAROUSEL,
   TT_GEN_OBJECT,
   TT_TMP_OBJECT,
   TT_PREFETCH_DIR_OBJ,
   TT_PREFETCH_NON_DIR_OBJ,
   TT_SSU_GROUP,
   TT_SSU_MODULE
} E_TargetType;

typedef void (*F_LoadFinalise)( P_DsmCoreInst idp, P_RootLoadRqst pLoadRequest );

typedef struct s_RootLoadRqst
{
   S_LLObject llData[NUM_LISTS_LOAD_REQUEST];
   U32BIT magic;
   E_LRStatus status;                       /* -- Curent load state */
   E_TargetType targetKind;                 /* -- Kind of final load target */
   H_Object target;
   F_LoadFinalise finalise;
   U32BIT remaining;
   E_CacheRules cachingRules;
   H_UsrRef usrRef;
   U8BIT percent;  /* download progress [0 - 100] */
} S_RootLoadRqst;

/*------------------------------  Exported Data  -----------------------------*/


/*---------------------------  Exported Prototypes  --------------------------*/

E_DscError DSC_LoadRsqtCreate( P_DsmCoreInst idp, U32BIT size,
   E_TargetType targetKind, H_Object target, F_LoadFinalise finalise, P_RootLoadRqst *ppLoadRqst );

void DSC_LoadRsqtDestroy( P_DsmCoreInst idp, P_RootLoadRqst pLoadRqst );

void DSC_LoadRsqtFinalise( P_DsmCoreInst idp, P_RootLoadRqst pLoadRqst );

void DSC_LoadRsqtNotify( P_DsmCoreInst idp, P_RootLoadRqst pLoadRqst, E_LRStatus status );

void DSC_LoadRsqtFinalNotify( P_DsmCoreInst idp, P_RootLoadRqst pLoadRqst, E_LRStatus status );

/**
 * @brief   Force abort (on error) any type of load request
 *          Finalise the load request (notify client) and destroy it.
 */
void DSC_LoadRsqtAbort( P_DsmCoreInst idp, P_RootLoadRqst pLoadRqst );

E_SFPriority DSC_LoadRsqtPriority( P_RootLoadRqst pLoadRqst );



/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#endif /* _LOADRQST_H_ */

