/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2001 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to the moduleData module.
 * @file    moduleData.h
 * @date    28/9/2001
 * @author  R Taylor
 */
#ifndef _MODULEDATA_H_
#define _MODULEDATA_H_


/*--------------------------------  Includes  --------------------------------*/

#include "clDsmSystem.h"
#include "object.h"
#include "defMemUtilsMgd.h"  /* -- Default mem type for module */


#ifdef __cplusplus
extern "C" {
#endif

/*-----------------------------  Exported Macros  ----------------------------*/


/*------------------------------  Exported Types  ----------------------------*/

/*------------------------------  Exported Data  -----------------------------*/


/*---------------------------  Exported Prototypes  --------------------------*/

E_DscError moduleDataCreate( P_DsmCoreInst idp,
   U32BIT dataSize, P_ModuleData *phModuleData );

void moduleDataDestroy( P_DsmCoreInst idp, P_ModuleData *phModuleData );

U32BIT moduleDataFindObject(
   /*I*/ P_ModuleData pModuleData, U32BIT dataLength, P_ObjectKey pObjectKey,
   /*O*/ MemPtr *mpObject );

MemPtr moduleDataPtr(P_ModuleData pModuleData);
MemPtr moduleDataOpen(P_ModuleData pModuleData);
void moduleDataClose(P_DsmCoreInst idp, P_ModuleData pModuleData);

/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#endif /* _MODULEDATA_H_ */
