/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2001 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to the moduleDecompress module.
 * @file    moduleDecompress.h
 * @date    28/9/2001
 * @author  R Taylor
 */
#ifndef _MODULEDECOMPRESS_H_
#define _MODULEDECOMPRESS_H_


/*--------------------------------  Includes  --------------------------------*/
#include "clDsmSystem.h"
#include "defMemUtilsMgd.h"  /* -- Default mem type for module */

#ifdef __cplusplus
extern "C" {
#endif


/*-----------------------------  Exported Macros  ----------------------------*/


/*------------------------------  Exported Types  ----------------------------*/


/*------------------------------  Exported Data  -----------------------------*/


/*---------------------------  Exported Prototypes  --------------------------*/

void moduleDecompressInit( P_DsmCoreInst idp );

E_DscError moduleDecompress( P_DsmCoreInst idp,
   /*I*/ U32BIT compressedSize, U32BIT decompressedSize,
   /*IO*/P_ModuleData hCompModuleData,
   /*O*/ P_ModuleData *ppModuleData );


/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#endif /* _MODULEDECOMPRESS_H_ */
