/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2001 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to the object module - functions/methods accessing data of
 *             object messages inside modules.
 * @file    object.h
 * @date    28/9/2001
 * @author  R Taylor
 */
#ifndef _OBJECT_H_
#define _OBJECT_H_



/*---includes for this file--------------------------------------------------*/

#include "clDsmSystem.h"
#include "linkList.h"
#include "defMemUtilsMgd.h"  /* -- Default mem type for module */


#ifdef __cplusplus
extern "C" {
#endif


/*---constant definitions for this file--------------------------------------*/

/* -- Settings for MHP = 254 + 1 for null (ETSI 101 812 section 14.1.4) */
#define MAX_OBJ_NAME_SIZE       255     /* -- Including null terminator */

/*---Constant and macro definitions for public use---------------------------*/

/*---Enumerations for public use---------------------------------------------*/

/*---Global type defs for public use-----------------------------------------*/

/* Object Data type and size info structure.
   All offsets are relative to start of object (BIOP) unless otherwise stated */
typedef struct
{
   S_ObjectKey objectKey;        /* Object key */
   U32BIT objectKind;            /* Object kind (e.g. file, ObjStream, etc) */
   U32BIT objectLen;             /* Total object length */
   U32BIT objectInfoOffset;      /* Offset to objectInfo field */
   U16BIT objectInfoLength;      /* Length of object information */
   U32BIT messageBodyOffset;     /* Offset to messageBody field */
   U32BIT messageBodyLength;     /* From start to end of messageBody */
} ObjectDataInfo_t, *pObjectDataInfo_t;



/*---Global variable declarations for public use-----------------------------*/


BOOLEAN objectDataGetKeyAndLen( const MemPtr mpObjectData,
   P_ObjectKey pObjectKey, U32BIT *pObjectLength );



/**
 * @brief   Parse the supplied object data.
 *          Verify selected fields.
 *          Extract relevant information from selected fields.
 *          Stote extracted information into structure supplied by calling function.
 * @param   mpObjectData The object data to be parsed.
 * @param   pObjInf The structure to be populated.
 * @return
 *          True on success.
 *          False on failure.
 */
BOOLEAN objectDataGetInfo(
   /*I*/ const MemPtr mpObjectData,
   /*O*/ ObjectDataInfo_t *pObjInf);



BOOLEAN odDirFindBinding(
   /*I*/ const MemPtr mpObject, pObjectDataInfo_t pObjInf, U8BIT *name,
   /*O*/ MemPtr *mpBinding );

BOOLEAN odDirGetBindingInfo(
   /*I*/ const MemPtr mpBinding,
   /*O*/ P_ObjectLocation pLocation, P_DeliveryParaTap pTap );

U8BIT odDirBindingNameLength(
   /*I*/ const MemPtr mpBinding );

U8BIT odDirBindingNameCopy(
   /*I*/ const MemPtr mpBinding,
   /*O*/ U8BIT *name );

BOOLEAN odDirGetBindingKind(
   /*I*/ const MemPtr mpBinding,
   /*O*/ U32BIT *pKind );

void odDirGetBindingsCount(
   /*I*/ const MemPtr mpObject, pObjectDataInfo_t pObjInf,
   /*O*/ U16BIT *pBindingsCount );

U16BIT odDirCountAndFirstBinding(
   /*I*/ const MemPtr mpObject, pObjectDataInfo_t pObjInf,
   /*O*/ MemPtr *mpFirstBinding );

BOOLEAN odDirGetNextBinding(
   /*I*/ const MemPtr mpCurrBinding,
   /*O*/ MemPtr *mpNextBinding );

/*----------------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
#endif /* _OBJECT_H_ */
