/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2001 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to the objectCarousel module.
 * @file    objectCarousel.h
 * @date    28/9/2001
 * @author  R Taylor
 */
#ifndef _OBJECTCAROUSEL_H_
#define _OBJECTCAROUSEL_H_


/*--------------------------------  Includes  --------------------------------*/

#include "rootCarousel.h"
#include "object.h"

#ifdef __cplusplus
extern "C" {
#endif

/*-----------------------------  Exported Macros  ----------------------------*/

/*------------------------------  Exported Types  ----------------------------*/

typedef struct FileGroupList_s *pFileGroupList_t;

typedef struct s_ObjectCarousel
{
   S_RootCarousel root;

   S_DeliveryParaTap srgTap;
   S_ObjectLocation srgObjLoc;
   pFileGroupList_t pFileGroupList;

   U32BIT srgObjectOffset;
   ObjectDataInfo_t srgObjectInfo;

   BOOLEAN bOCLiteOptionsObjectProcessing;
   U16BIT loadedObjectCount;

   P_LLControl llcCurrObjects;
   P_LLControl llcOcPostponedLiteObjectLoads;
} S_ObjectCarousel;


/*------------------------------  Exported Data  -----------------------------*/


/*---------------------------  Exported Prototypes  --------------------------*/

E_DscError DSC_ObjCrslCreate( P_DsmCoreInst idp, U16BIT serviceId,
   U32BIT carouselId, P_ObjectCarousel *ppObjectCarousel );

void DSC_ObjCrslDestroy( P_DsmCoreInst idp, P_ObjectCarousel *ppObjectCarousel );

E_DscError DSC_ObjCrslParseSrgInfo( P_DsmCoreInst idp, P_ObjectCarousel pOC,
   U8BIT *pDsiPrivate, U16BIT dsiPrivateLen );

void DSC_ObjCrslUpdateSuiLoaded( P_DsmCoreInst idp, P_ObjectCarousel pOC );

E_DscError DSC_ObjCrslRetrieveFileGroups( P_ObjectCarousel pOC, U16BIT *total,
   S_CarouselInfoFileGroup **pGroups );

void DSC_ObjCrslReleaseFileGroups( P_DsmCoreInst idp, P_ObjectCarousel pOC, S_CarouselInfoFileGroup *groups );

E_DscError DSC_ObjCrslUnloadObjects( P_DsmCoreInst idp, P_ObjectCarousel pOC, E_DsmRstMode mode );

BOOLEAN DSC_ObjCrslSrgObjectLoaded( P_ObjectCarousel pOC );

P_Module DSC_ObjCrslSrgModule( P_ObjectCarousel pOC );

void DSC_ObjCrslSrgObjectReset( P_ObjectCarousel pOC );

/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#endif /* _OBJECTCAROUSEL_H_ */

