/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   DSM-CC functions related to PMT update
 * @file    pmtUpdate.c
 * @date    01/12/2004
 * @author  Ocean Blue
 */

/*---includes for this file--------------------------------------------------*/

#include "clDsmUtils.h"
#include "linkList.h"
#include "module.h"
#include "dataCarousel.h"
#include "rootCarousel.h"


#include "pmtUpdate.h"
#include "streamEvent.h"

/*******************************************************************************
 * **** STUB - NOT YET IMPLEMENTED (REQUIRED FOR MHEG5) ****
 *
 * Notify that the SI for the indicated service has changed
 *
 *******************************************************************************/
E_DscError pmtUpdtAllSectionFiltersReset( H_DsmCoreInst idp, U16BIT service_id )
{
   E_DscError err = CLDSM_OK;
   P_RootCarousel pRC;
   ListId_t listId;
   ListId_t moduleListId;
   P_Module pModuleFromList = NULL;
   P_DataCarousel pDC;
   ListId_t dcListId;

   dsmAssert((idp !=  NULL));

   dsmDP2(("pmtUpdtAllSectionFiltersReset(%d)\n",service_id));

   /* Get listId and first OC in list from Control block */
   listId = LListId( idp->llcRootCarousels );
   pRC = LLHead( idp->llcRootCarousels );

   while (pRC)
   {
      if (pRC->serviceId == service_id)
      {
         /* check DsiSf */
         /*-------------*/
         dsmDP2(("check DsiSf\n"));
         err = DSC_RootCrslAcquireRestart(idp, pRC);

         /* check SRG data carousel filter */
         pDC = DSC_RootCrslFirstDataCarousel( pRC );
         if (pDC != NULL)
         {
            dsmDP2(("check DiiSf\n"));
            DSC_DataCrslAcquireRestart(idp, pDC);
         }

         /* get module list */
         if (pRC->llcDataCarousels != NULL)
         {
            dcListId = LListId( pRC->llcDataCarousels );
            pDC = LLHead( pRC->llcDataCarousels );

            while (pDC)
            {
               if (pDC->llcModuleAcquires != NULL)
               {
                  moduleListId = LListId( pDC->llcModuleAcquires );
                  pModuleFromList = LLHead( pDC->llcModuleAcquires );

                  /* Go through each module in list until the one with a matching moduleId is found */
                  while (pModuleFromList)
                  {
                     /* check DDB filter */
                     /*------------------*/
                     dsmDP2(("check module Id %d\n", pModuleFromList->moduleInfo.moduleId));
                     err = DSC_ModuleAcquireRestart(idp, pModuleFromList);
                     pModuleFromList = LLNext( pModuleFromList, moduleListId );
                  }
               }
               pDC = LLNext( pDC, dcListId );
            }
         }

         /* get DII list */
         if (pRC->llcDiiAcquires != NULL)
         {
            dcListId = LListId( pRC->llcDiiAcquires );
            pDC = LLHead( pRC->llcDiiAcquires );

            while (pDC)
            {
               DSC_DataCrslAcquireRestart(idp, pDC);
               pDC = LLNext( pDC, dcListId );
            }
         }
      }
      pRC = LLNext( pRC, listId );
   }

   DSC_StrmEventFilterReset( idp );

   DEBUG_CHK( err == CLDSM_OK, dsmDP1(("ERROR: pmtUpdtAllSectionFiltersReset: %u\n", err)));
   return(err);
}

