/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 * Copyright  2001 Koninklijke Philips Electronics N.V
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header to the sectionFilter module
 * @file    sectionFilter.h
 * @date    28/9/2001
 * @author  R Taylor
 */
#ifndef _SECTIONFILTER_H_
#define _SECTIONFILTER_H_


/*--------------------------------  Includes  --------------------------------*/

#include "clDsmSystem.h"


#ifdef __cplusplus
extern "C" {
#endif


/*-----------------------------  Exported Macros  ----------------------------*/

/*------------------------------  Exported Types  ----------------------------*/

/* -- Internal section filter types */

typedef enum
{
   SFK_NONE = 0,
   SFK_DSI,
   SFK_DII,
   SFK_DII_NEXT,
   SFK_DDB,
   SFK_STREAM_DESCR
} E_SecFiltKind;

typedef struct s_SfTarget
{
   E_SecFiltKind kind;
   U32BIT id;
   U16BIT serviceId;
   U16BIT associationTag;
   union
   {
      P_ObjectCarousel pOC;
      P_RootCarousel pRC;
      P_DataCarousel pDC;
      P_Module pModule;
      P_Event pEvent;
   } u;
} S_SfTarget, *P_SfTarget;

typedef enum
{
   SFA_INITIAL = 0,
   SFA_PENDING,
   SFA_COMMITTED,
   SFA_ABORTED
} E_SfStatus;

typedef struct s_DscTimerManagement
{
   void *mainTimerHandle;
   void *nextTimerHandle;
   U32BIT mainDuration;
   U32BIT nextDuration;
} S_DscTimerManagement;

typedef struct s_SecFilterInfo *P_SecFilterInfo;

typedef struct s_SecFilterInfo
{
   S_SecFilter filter;

   U32BIT handle;

   E_SfStatus status;

   /* Target is a carousel, module, or stream event */
   S_SfTarget target;

   /* -- Timer management */
   S_DscTimerManagement tms;

   P_SecFilterInfo nextBlock;

   /* -- Following fields are never required simultaneously */
   union
   {
      P_SiQuery pPendingSiQueryRef; /* -- Use when SFA_PENDING */
      void *filterHandle;           /* -- Use when SFA_COMMITTED */
   } u;
} S_SecFilterInfo;


/*------------------------------  Exported Data  -----------------------------*/


/*---------------------------  Exported Prototypes  --------------------------*/

E_DscError DSC_SsectionFilterHeapCreate( P_DsmCoreInst idp,
   /*O*/ void **pSectionFilterHeap, U32BIT *pHeapSize );

void DSC_SsectionFilterHeapReset( P_DsmCoreInst idp );

E_DscError DSC_SectionFilterStart( P_DsmCoreInst idp, P_SfTarget target,
   E_SFPriority sfPriority, P_SecFilterInfo *pSectionFilter );

E_DscError DSC_SsectionFilterUpdatePriority( P_DsmCoreInst idp,
   P_SecFilterInfo pSF, E_SFPriority newSfPriority, BOOLEAN latchHighest );

E_DscError DSC_SectionFilterCommit( P_DsmCoreInst idp, P_SecFilterInfo pSectionFilter );

void DSC_SectionFilterStop( P_DsmCoreInst idp, P_SecFilterInfo *pSectionFilter );

void DSC_SectionFilterAbortDependants( P_DsmCoreInst idp, P_SecFilterInfo pSectionFilter );

P_SecFilterInfo DSC_SectionFilterRetrieve( P_DsmCoreInst idp, U32BIT handle );

/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#endif /* _SECTIONFILTER_H_ */
